/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.util.function.Supplier;
import net.openhft.chronicle.bytes.Byteable;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.core.values.LongValue;

public class LongTextReference
implements LongValue,
Byteable {
    public static final byte[] template = "!!atomic { locked: false, value: 00000000000000000000 }".getBytes();
    public static final int FALSE = BytesUtil.asInt((String)"fals");
    public static final int TRUE = BytesUtil.asInt((String)" tru");
    static final long UNINITIALIZED = 0L;
    static final int LOCKED = 19;
    static final int VALUE = 33;
    private static final int DIGITS = 20;
    private BytesStore bytes;
    private long offset;

    <T> T withLock(Supplier<T> call) {
        long valueOffset = this.offset + 19L;
        int value = this.bytes.readVolatileInt(valueOffset);
        if (value != FALSE && value != TRUE) {
            throw new IllegalStateException();
        }
        while (!this.bytes.compareAndSwapInt(valueOffset, FALSE, TRUE)) {
        }
        T t = call.get();
        this.bytes.writeOrderedInt(valueOffset, FALSE);
        return t;
    }

    public long getValue() {
        return this.withLock(() -> this.bytes.parseLong(this.offset + 33L));
    }

    public void setValue(long value) {
        this.withLock(() -> this.bytes.append(this.offset + 33L, value, 20));
    }

    public long getVolatileValue() {
        return this.getValue();
    }

    public void setOrderedValue(long value) {
        this.setValue(value);
    }

    public long addValue(long delta) {
        return this.withLock(() -> {
            long value = this.bytes.parseLong(this.offset + 33L) + delta;
            this.bytes.append(this.offset + 33L, value, 20);
            return value;
        });
    }

    public long addAtomicValue(long delta) {
        return this.addValue(delta);
    }

    public boolean compareAndSwapValue(long expected, long value) {
        return this.withLock(() -> {
            if (this.bytes.parseLong(this.offset + 33L) == expected) {
                this.bytes.append(this.offset + 33L, value, 20);
                return true;
            }
            return false;
        });
    }

    public void bytesStore(BytesStore bytes, long offset, long length) {
        if (length != (long)template.length) {
            throw new IllegalArgumentException();
        }
        this.bytes = bytes;
        this.offset = offset;
        if (bytes.readLong(offset) == 0L) {
            bytes.write(offset, template);
        }
    }

    public BytesStore bytesStore() {
        return this.bytes;
    }

    public long offset() {
        return this.offset;
    }

    public long maxSize() {
        return template.length;
    }

    public static void write(Bytes bytes, long value) {
        long position = bytes.position();
        bytes.write(template);
        bytes.append(position + 33L, value, 20);
    }

    public String toString() {
        return "value: " + this.getValue();
    }
}

