/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import net.openhft.chronicle.bytes.Byteable;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.core.values.LongArrayValues;

public class LongArrayDirectReference
implements LongArrayValues,
Byteable {
    private static final long CAPACITY = 0L;
    private static final long VALUES = 8L;
    private BytesStore bytes;
    private long offset;
    private long length = 8L;

    public long getCapacity() {
        return this.length - 8L >>> 3;
    }

    public long getValueAt(long index) {
        return this.bytes.readLong(8L + this.offset + index << 3);
    }

    public void setValueAt(long index, long value) {
        this.bytes.writeLong(8L + this.offset + index << 3, value);
    }

    public long getVolatileValueAt(long index) {
        return this.bytes.readVolatileLong(8L + this.offset + index << 3);
    }

    public void setOrderedValueAt(long index, long value) {
        this.bytes.writeOrderedLong(8L + this.offset + index << 3, value);
    }

    public void bytesStore(BytesStore bytes, long offset, long length) {
        if (length != LongArrayDirectReference.peakLength(bytes, offset)) {
            throw new IllegalArgumentException(length + " != " + LongArrayDirectReference.peakLength(bytes, offset));
        }
        this.bytes = bytes;
        this.offset = offset;
        this.length = length;
    }

    public static long peakLength(BytesStore bytes, long offset) {
        return (bytes.readLong(offset + 0L) << 3) + 8L;
    }

    public BytesStore bytesStore() {
        return this.bytes;
    }

    public long offset() {
        return this.offset;
    }

    public long maxSize() {
        return this.length;
    }

    public String toString() {
        return "value: " + this.getValueAt(0L) + " ...";
    }

    public static void write(Bytes bytes, long capacity) {
        bytes.writeLong(capacity);
        long start = bytes.position() + 8L;
        bytes.zeroOut(start, start + (capacity << 3));
        bytes.skip(capacity << 3);
    }

    public static void lazyWrite(Bytes bytes, long capacity) {
        bytes.writeLong(capacity);
        bytes.skip(capacity << 3);
    }
}

