/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single.work.in.progress;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.MappedFile;
import net.openhft.chronicle.bytes.NativeBytes;
import net.openhft.chronicle.bytes.VanillaBytes;
import net.openhft.chronicle.core.annotation.ForceInline;
import net.openhft.chronicle.core.values.LongArrayValues;
import net.openhft.chronicle.core.values.LongValue;
import net.openhft.chronicle.queue.Excerpt;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.impl.single.work.in.progress.AbstractChronicle;
import net.openhft.chronicle.queue.impl.single.work.in.progress.Compression;
import net.openhft.chronicle.queue.impl.single.work.in.progress.Header;
import net.openhft.chronicle.queue.impl.single.work.in.progress.Indexer;
import net.openhft.chronicle.queue.impl.single.work.in.progress.SingleAppender;
import net.openhft.chronicle.queue.impl.single.work.in.progress.SingleTailer;
import net.openhft.chronicle.wire.BinaryWire;
import net.openhft.chronicle.wire.ByteableLongArrayValues;
import net.openhft.chronicle.wire.RawWire;
import net.openhft.chronicle.wire.ReadMarshallable;
import net.openhft.chronicle.wire.TextWire;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.Wires;
import net.openhft.chronicle.wire.WriteMarshallable;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexedSingleChronicleQueue
extends AbstractChronicle {
    static final long HEADER_OFFSET = 8L;
    static final long UNINITIALISED = 0L;
    static final long BUILDING = IndexedSingleChronicleQueue.toLong("BUILDING");
    static final long QUEUE_CREATED = IndexedSingleChronicleQueue.toLong("QUEUE400");
    static final int NOT_READY = Integer.MIN_VALUE;
    static final int META_DATA = 0x40000000;
    static final int LENGTH_MASK = 0x3FFFFFFF;
    static final int MAX_LENGTH = 0x3FFFFFFF;
    private static final long MAGIC_OFFSET = 0L;
    private static final Logger LOG = LoggerFactory.getLogger((String)IndexedSingleChronicleQueue.class.getName());
    final Header header = new Header();
    @NotNull
    final Wire wire;
    private final ThreadLocal<ExcerptAppender> localAppender = new ThreadLocal();
    @NotNull
    private final MappedFile mappedFile;
    private final Bytes headerMemory;
    @NotNull
    private final Bytes bytes;
    private final Function<Bytes, Wire> bytesToWireFunction;
    private final ThreadLocal<ByteableLongArrayValues> longArray;
    private final WireType wireType;
    private long firstBytes = -1L;

    @ForceInline
    private static long toLong(String str) {
        Bytes bytes = Bytes.allocateDirect((byte[])str.getBytes());
        return bytes.readLong();
    }

    public IndexedSingleChronicleQueue(@NotNull String filename, long blockSize, @NotNull WireType wireType) throws IOException {
        this.header.init(Compression.NONE, wireType);
        this.mappedFile = MappedFile.mappedFile((String)filename, (long)blockSize);
        this.headerMemory = this.mappedFile.acquireBytesForWrite(0L);
        this.bytes = this.mappedFile.acquireBytesForWrite(0L);
        this.wire = IndexedSingleChronicleQueue.createWire(wireType, this.bytes);
        this.wireType = wireType;
        this.bytesToWireFunction = wireType;
        this.longArray = Indexer.newLongArrayValuesPool(this.wireType);
        this.initialiseHeader();
    }

    private static Wire createWire(@NotNull WireType wireType, @NotNull Bytes bytes) {
        return (Wire)wireType.apply((Object)bytes);
    }

    static Function<Bytes, Wire> byteToWireFor(Class<? extends Wire> wireType) {
        if (TextWire.class.isAssignableFrom(wireType)) {
            return TextWire::new;
        }
        if (BinaryWire.class.isAssignableFrom(wireType)) {
            return BinaryWire::new;
        }
        if (RawWire.class.isAssignableFrom(wireType)) {
            return RawWire::new;
        }
        throw new UnsupportedOperationException("todo");
    }

    private void initialiseHeader() throws IOException {
        if (this.bytes.compareAndSwapLong(0L, 0L, BUILDING)) {
            this.buildHeader();
        }
        this.readHeader();
    }

    private void buildHeader() {
        this.bytes.writePosition(8L);
        this.wire.writeDocument(true, w -> w.write((WireKey)MetaDataKey.header).marshallable((WriteMarshallable)this.header.init(Compression.NONE, this.wireType)));
        if (!this.bytes.compareAndSwapLong(0L, BUILDING, QUEUE_CREATED)) {
            throw new AssertionError((Object)"Concurrent writing of the header");
        }
    }

    private void readHeader() throws IOException {
        this.waitForTheHeaderToBeBuilt(this.bytes);
        this.bytes.readPosition(8L);
        if (!this.wire.readDocument(w -> w.read().marshallable((ReadMarshallable)this.header), null)) {
            throw new AssertionError((Object)"No header!?");
        }
        this.firstBytes = this.bytes.writePosition();
    }

    private void waitForTheHeaderToBeBuilt(@NotNull Bytes bytes) throws IOException {
        for (int i = 0; i < 1000; ++i) {
            long magic = bytes.readVolatileLong(0L);
            if (magic == BUILDING) {
                try {
                    Thread.sleep(10L);
                    continue;
                }
                catch (InterruptedException e) {
                    throw new IOException("Interrupted waiting for the header to be built");
                }
            }
            if (magic == QUEUE_CREATED) {
                return;
            }
            throw new AssertionError((Object)("Invalid magic number " + Long.toHexString(magic) + " in file " + this.name()));
        }
        throw new AssertionError((Object)("Timeout waiting to build the file " + this.name()));
    }

    @Override
    public String name() {
        return this.mappedFile.toString();
    }

    @Override
    @NotNull
    public Excerpt createExcerpt() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public ExcerptTailer createTailer() throws IOException {
        return new SingleTailer(this, this.bytesToWireFunction, this.wireType);
    }

    @Override
    @NotNull
    public ExcerptAppender createAppender() throws IOException {
        ExcerptAppender appender = this.localAppender.get();
        if (appender == null) {
            appender = new SingleAppender(this, this.bytesToWireFunction);
            this.localAppender.set(appender);
        }
        return appender;
    }

    @Override
    public long size() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long firstAvailableIndex() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long lastWrittenIndex() {
        return this.header.lastIndex().getVolatileValue();
    }

    static String getHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            try {
                return Files.readAllLines(Paths.get("etc", "hostname")).get(0);
            }
            catch (Exception e2) {
                return "localhost";
            }
        }
    }

    @Override
    protected Wire wire() {
        throw new UnsupportedOperationException("todo");
    }

    @Override
    public Class<? extends Wire> wireType() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long indexToIndex() {
        while (true) {
            long index2Index;
            if ((index2Index = this.header.index2Index().getVolatileValue()) == Integer.MIN_VALUE) {
                continue;
            }
            if (index2Index != 0L) {
                return index2Index;
            }
            if (this.header.index2Index().compareAndSwapValue(0L, Integer.MIN_VALUE)) break;
        }
        long indexToIndex = this.newIndex();
        this.header.index2Index().setOrderedValue(indexToIndex);
        return indexToIndex;
    }

    @Override
    public long newIndex() {
        LongArrayValues array = (LongArrayValues)this.longArray.get();
        long size = array.sizeInBytes(131072L);
        NativeBytes buffer = NativeBytes.nativeBytes((long)size);
        buffer.zeroOut(0L, size);
        BinaryWire wire = new BinaryWire((Bytes)buffer);
        wire.write(() -> "index").int64array(131072L);
        return this.appendMetaDataReturnAddress((Bytes)buffer);
    }

    private long appendMetaDataReturnAddress(@NotNull Bytes buffer) {
        long length = buffer.writeRemaining();
        if (length > 0x3FFFFFFFL) {
            throw new IllegalStateException("Length too large: " + length);
        }
        LongValue writeByte = this.header.writeByte();
        long lastByte = writeByte.getVolatileValue();
        while (true) {
            if (this.bytes.compareAndSwapInt(lastByte, 0, Integer.MIN_VALUE | (int)length)) {
                long lastByte2 = lastByte + 4L + buffer.writeRemaining();
                this.bytes.write(lastByte + 4L, buffer);
                writeByte.setOrderedValue(lastByte2);
                this.bytes.writeOrderedInt(lastByte, (int)(0x40000000L | length));
                return lastByte;
            }
            int length2 = this.length30(this.bytes.readVolatileInt());
            this.bytes.writeSkip((long)length2);
        }
    }

    @Override
    public void close() {
        throw new UnsupportedOperationException();
    }

    public long appendDocument(@NotNull Bytes buffer) {
        long length = buffer.readRemaining();
        if (length > 0x3FFFFFFFL) {
            throw new IllegalStateException("Length too large: " + length);
        }
        LongValue writeByte = this.header.writeByte();
        while (true) {
            long lastByte;
            if (this.bytes.compareAndSwapInt(lastByte = writeByte.getVolatileValue(), 0, Integer.MIN_VALUE | (int)length)) {
                long lastByte2 = lastByte + 4L + buffer.writeRemaining();
                this.bytes.write(lastByte + 4L, buffer);
                long lastIndex = this.header.lastIndex().addAtomicValue(1L);
                writeByte.setOrderedValue(lastByte2);
                this.bytes.writeOrderedInt(lastByte, (int)length);
                return lastIndex;
            }
            int length2 = this.length30(this.bytes.readVolatileInt());
            this.bytes.writeSkip((long)length2);
        }
    }

    public boolean readDocument(long offset, ReadMarshallable buffer) {
        throw new UnsupportedOperationException("todo");
    }

    public boolean readDocument(@NotNull AtomicLong offset, @NotNull Bytes buffer) {
        buffer.clear();
        long lastByte = offset.get();
        do {
            int length = this.bytes.readVolatileInt(lastByte);
            int length2 = this.length30(length);
            if (!Wires.isReady((long)length)) continue;
            buffer.write((BytesStore)this.bytes, lastByte += 4L, (long)length2);
            offset.set(lastByte += (long)length2);
            return Wires.isData((long)length);
        } while (!Thread.currentThread().isInterrupted());
        return false;
    }

    @NotNull
    public Bytes bytes() {
        return this.bytes;
    }

    public long lastIndex() {
        long value = this.header.lastIndex().getVolatileValue();
        if (value == -1L) {
            throw new IllegalStateException("No data has been written to chronicle.");
        }
        return value;
    }

    public boolean index(long index, @NotNull VanillaBytes bytes) {
        if (index == -1L) {
            bytes.bytesStore((BytesStore)this.headerMemory, 8L, (long)this.headerMemory.length() - 8L);
            return true;
        }
        return false;
    }

    public long firstBytes() {
        return this.firstBytes;
    }

    private int length30(int i) {
        return i & 0x3FFFFFFF;
    }

    static enum MetaDataKey implements WireKey
    {
        header,
        index2index,
        index;

    }
}

