/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single.work.in.progress;

import java.time.ZonedDateTime;
import java.util.UUID;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.NativeBytes;
import net.openhft.chronicle.core.values.LongValue;
import net.openhft.chronicle.queue.impl.single.work.in.progress.Compression;
import net.openhft.chronicle.wire.BinaryLongReference;
import net.openhft.chronicle.wire.Marshallable;
import net.openhft.chronicle.wire.TextLongReference;
import net.openhft.chronicle.wire.TextWire;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.WriteMarshallable;
import org.jetbrains.annotations.NotNull;

public class Header
implements Marshallable {
    public static final long PADDED_SIZE = 512L;
    UUID uuid;
    ZonedDateTime created;
    String user;
    String compression;
    int indexCount = 131072;
    int indexSpacing = 64;
    private LongValue writeByte = null;
    private LongValue index2Index = null;
    private LongValue lastIndex = null;

    public LongValue writeByte() {
        return this.writeByte;
    }

    LongValue index2Index() {
        return this.index2Index;
    }

    LongValue lastIndex() {
        return this.lastIndex;
    }

    @NotNull
    public Header init(@NotNull Compression compression, WireType wireType) {
        this.uuid = UUID.randomUUID();
        this.created = ZonedDateTime.now();
        this.user = System.getProperty("user.name");
        this.compression = compression.name();
        this.writeByte = this.newLongValue(wireType);
        this.index2Index = this.newLongValue(wireType);
        this.lastIndex = this.newLongValue(wireType);
        return this;
    }

    LongValue newLongValue(WireType wireType) {
        BinaryLongReference value;
        if (wireType == WireType.BINARY) {
            BinaryLongReference value0 = new BinaryLongReference();
            value0.bytesStore((BytesStore)NativeBytes.nativeBytes((long)8L), 0L, 8L);
            value = value0;
        } else if (wireType == WireType.TEXT) {
            TextLongReference value0 = new TextLongReference();
            value0.bytesStore((BytesStore)NativeBytes.nativeBytes((long)55L), 0L, 55L);
            value = value0;
        } else {
            throw new IllegalStateException("type not supported");
        }
        return value;
    }

    public void writeMarshallable(@NotNull WireOut out) {
        out.write((WireKey)Field.uuid).uuid(this.uuid).write((WireKey)Field.writeByte).int64forBinding(512L).write((WireKey)Field.created).zonedDateTime(this.created).write((WireKey)Field.user).text((CharSequence)this.user).write((WireKey)Field.compression).text((CharSequence)this.compression).write((WireKey)Field.indexCount).int32(this.indexCount).write((WireKey)Field.indexSpacing).int32(this.indexSpacing).write((WireKey)Field.index2Index).int64forBinding(0L).write((WireKey)Field.lastIndex).int64forBinding(-1L);
        out.addPadding((int)(512L - out.bytes().writePosition()));
    }

    public void readMarshallable(@NotNull WireIn in) {
        in.read((WireKey)Field.uuid).uuid((Object)this, (o, u) -> {
            o.uuid = u;
        }).read((WireKey)Field.writeByte).int64((Object)this, (header, value) -> header.writeByte.setValue(value)).read((WireKey)Field.created).zonedDateTime((Object)this, (o, c) -> {
            o.created = c;
        }).read((WireKey)Field.user).text((Object)this, (o, u) -> {
            o.user = u;
        }).read((WireKey)Field.compression).text((Object)this, (o, h) -> {
            o.compression = h;
        }).read((WireKey)Field.indexCount).int32((Object)this, (o, h) -> {
            o.indexCount = h;
        }).read((WireKey)Field.indexSpacing).int32((Object)this, (o, h) -> {
            o.indexSpacing = h;
        }).read((WireKey)Field.index2Index).int64((Object)this, (header, value) -> header.index2Index.setValue(value)).read((WireKey)Field.lastIndex).int64((Object)this, (header, value) -> header.lastIndex.setValue(value));
    }

    public long getWriteByte() {
        return this.writeByte().getVolatileValue();
    }

    public static void main(String ... args) {
        Header h = new Header();
        h.init(Compression.NONE, WireType.TEXT);
        TextWire tw = new TextWire((Bytes)NativeBytes.nativeBytes());
        tw.writeDocument(true, w -> w.write(() -> "header").marshallable((WriteMarshallable)h));
        System.out.println(tw.bytes().toString());
    }

    static enum Field implements WireKey
    {
        type,
        uuid,
        created,
        user,
        host,
        compression,
        indexCount,
        indexSpacing,
        writeByte,
        index2Index,
        lastIndex;

    }
}

