/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.Closeable;
import java.io.IOException;
import java.time.ZoneId;
import java.util.function.Function;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.IORuntimeException;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.ReferenceCounter;
import net.openhft.chronicle.core.pool.ClassAliasPool;
import net.openhft.chronicle.core.values.LongValue;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.impl.WireBoundsConsumer;
import net.openhft.chronicle.queue.impl.WireConstants;
import net.openhft.chronicle.queue.impl.WirePool;
import net.openhft.chronicle.queue.impl.WireStore;
import net.openhft.chronicle.wire.Marshallable;
import net.openhft.chronicle.wire.ReadMarshallable;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.Wires;
import net.openhft.chronicle.wire.WriteMarshallable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SingleChronicleQueueStore
implements WireStore {
    private BytesStore bytesStore;
    private WirePool wirePool;
    private Closeable resourceCleaner;
    private final ReferenceCounter refCount = ReferenceCounter.onReleased(this::performRelease);
    private final Bounds bounds = new Bounds();
    private final Indexing indexing;
    private final Roll roll;

    SingleChronicleQueueStore() {
        this(null);
    }

    SingleChronicleQueueStore(@Nullable RollCycle rollCycle) {
        this.roll = new Roll(rollCycle);
        this.indexing = new Indexing();
        this.resourceCleaner = null;
    }

    @Override
    public long readPosition() {
        return this.bounds.getReadPosition();
    }

    @Override
    public long writePosition() {
        return this.bounds.getWritePosition();
    }

    @Override
    public long cycle() {
        return this.roll.getCycle();
    }

    @Override
    public long lastIndex() {
        return this.indexing.getLastIndex();
    }

    @Override
    public boolean appendRollMeta(long cycle) throws IOException {
        if (this.roll.casNextRollCycle(cycle)) {
            this.append((lower, upper) -> this.roll.setNextCycleMetaPosition(lower), true, w -> w.write((WireKey)MetaDataField.roll).int32(cycle));
            return true;
        }
        return false;
    }

    @Override
    public long append(@NotNull WriteMarshallable writer) throws IOException {
        this.append((lower, upper) -> this.bounds.setWritePositionIfGreater(upper), false, writer);
        return this.indexing.incrementLastIndex();
    }

    @Override
    public long read(long position, @NotNull ReadMarshallable reader) throws IOException {
        int spbHeader = this.bytesStore.readVolatileInt(position);
        if (Wires.isNotInitialized((int)spbHeader)) {
            return 0L;
        }
        if (Wires.isData((long)spbHeader) && Wires.isReady((long)spbHeader)) {
            return Wires.readData((WireIn)this.wirePool.acquireForReadAt(position), (ReadMarshallable)reader);
        }
        if (Wires.isKnownLength((int)spbHeader)) {
            StringBuilder sb = WireConstants.SBP.acquireStringBuilder();
            ValueIn vi = this.wirePool.acquireForReadAt(position + 4L).read(sb);
            if ("roll".contentEquals(sb)) {
                return -vi.int32();
            }
            return this.read(position += (long)Wires.lengthOf((long)spbHeader) + 4L, reader);
        }
        return 0L;
    }

    @Override
    public long positionForIndex(long index) {
        long position = this.readPosition();
        for (long i = 0L; i <= index; ++i) {
            int spbHeader = this.bytesStore.readVolatileInt(position);
            if (!Wires.isData((long)spbHeader) || !Wires.isKnownLength((int)spbHeader)) continue;
            if (index == i) {
                return position;
            }
            position += (long)Wires.lengthOf((long)spbHeader) + 4L;
        }
        return -1L;
    }

    protected void checkRemainingForAppend() {
        long remaining = this.bytesStore.writeRemaining();
        if (Wires.exceedsMaxLength((long)remaining)) {
            throw new IllegalStateException("Length too large: " + remaining);
        }
    }

    @Override
    public void install(@NotNull BytesStore store, long length, boolean created, long cycle, @NotNull Function<Bytes, Wire> wireSupplier, @Nullable Closeable closeable) throws IOException {
        this.bytesStore = store;
        this.wirePool = new WirePool(this.bytesStore, wireSupplier);
        if (created) {
            this.bounds.setWritePosition(length);
            this.bounds.setReadPosition(length);
            this.roll.setCycle(cycle);
        }
    }

    protected void append(@NotNull WireBoundsConsumer consumer, boolean meta, @NotNull WriteMarshallable writer) throws IOException {
        this.checkRemainingForAppend();
        long TIMEOUT_MS = 10000L;
        long end = System.currentTimeMillis() + TIMEOUT_MS;
        long lastWritePosition = this.writePosition();
        while (true) {
            if (Wires.acquireLock((BytesStore)this.bytesStore, (long)lastWritePosition)) {
                consumer.accept(lastWritePosition, !meta ? Wires.writeData((WireOut)this.wirePool.acquireForWriteAt(lastWritePosition), (WriteMarshallable)writer) : Wires.writeMeta((WireOut)this.wirePool.acquireForWriteAt(lastWritePosition), (WriteMarshallable)writer));
                return;
            }
            int spbHeader = this.bytesStore.readInt(lastWritePosition);
            if (Wires.isKnownLength((int)spbHeader)) {
                lastWritePosition += (long)Wires.lengthOf((long)spbHeader) + 4L;
                continue;
            }
            if (System.currentTimeMillis() > end) {
                throw new AssertionError((Object)"Timeout waiting to append");
            }
            Jvm.pause((long)1L);
        }
    }

    private synchronized void performRelease() {
        try {
            if (this.resourceCleaner != null) {
                this.resourceCleaner.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void reserve() throws IllegalStateException {
        this.refCount.reserve();
    }

    public void release() throws IllegalStateException {
        this.refCount.release();
    }

    public long refCount() {
        return this.refCount.get();
    }

    public void writeMarshallable(@NotNull WireOut wire) {
        wire.write((WireKey)MetaDataField.bounds).typedMarshallable((WriteMarshallable)this.bounds).write((WireKey)MetaDataField.indexing).typedMarshallable((WriteMarshallable)this.indexing).write((WireKey)MetaDataField.roll).typedMarshallable((WriteMarshallable)this.roll);
    }

    public void readMarshallable(@NotNull WireIn wire) throws IORuntimeException {
        wire.read((WireKey)MetaDataField.bounds).marshallable((ReadMarshallable)this.bounds).read((WireKey)MetaDataField.indexing).marshallable((ReadMarshallable)this.indexing).read((WireKey)MetaDataField.roll).marshallable((ReadMarshallable)this.roll);
    }

    static {
        ClassAliasPool.CLASS_ALIASES.addAlias(Bounds.class, "Bounds");
        ClassAliasPool.CLASS_ALIASES.addAlias(Indexing.class, "Indexing");
        ClassAliasPool.CLASS_ALIASES.addAlias(Roll.class, "Roll");
    }

    class Roll
    implements Marshallable {
        private int length;
        private String format;
        private ZoneId zoneId;
        private LongValue cycle;
        private LongValue nextCycle;
        private LongValue nextCycleMetaPosition;

        Roll(RollCycle rollCycle) {
            this.length = rollCycle != null ? rollCycle.length() : -1;
            this.format = rollCycle != null ? rollCycle.format() : null;
            this.zoneId = rollCycle != null ? rollCycle.zone() : null;
            this.cycle = null;
            this.nextCycle = null;
            this.nextCycleMetaPosition = null;
        }

        public void writeMarshallable(@NotNull WireOut wire) {
            this.cycle = wire.newLongReference();
            this.nextCycle = wire.newLongReference();
            this.nextCycleMetaPosition = wire.newLongReference();
            wire.write((WireKey)RollFields.cycle).int64forBinding(-1L, this.cycle).write((WireKey)RollFields.length).int32(this.length).write((WireKey)RollFields.format).text((CharSequence)this.format).write((WireKey)RollFields.timeZone).text((CharSequence)this.zoneId.getId()).write((WireKey)RollFields.nextCycle).int64forBinding(-1L, this.nextCycle).write((WireKey)RollFields.nextCycleMetaPosition).int64forBinding(-1L, this.nextCycleMetaPosition);
        }

        public void readMarshallable(@NotNull WireIn wire) {
            wire.read((WireKey)RollFields.cycle).int64(this.cycle, (Object)this, (o, i) -> {
                o.cycle = i;
            }).read((WireKey)RollFields.length).int32((Object)this, (o, i) -> {
                o.length = i;
            }).read((WireKey)RollFields.format).text((Object)this, (o, i) -> {
                o.format = i;
            }).read((WireKey)RollFields.timeZone).text((Object)this, (o, i) -> {
                o.zoneId = ZoneId.of(i);
            }).read((WireKey)RollFields.nextCycle).int64(this.nextCycle, (Object)this, (o, i) -> {
                o.nextCycle = i;
            }).read((WireKey)RollFields.nextCycleMetaPosition).int64(this.nextCycleMetaPosition, (Object)this, (o, i) -> {
                o.nextCycleMetaPosition = i;
            });
        }

        public long getCycle() {
            return this.cycle.getVolatileValue();
        }

        public Roll setCycle(long rollCycle) {
            this.cycle.setOrderedValue(rollCycle);
            return this;
        }

        public Roll setNextCycleMetaPosition(long position) {
            this.nextCycleMetaPosition.setOrderedValue(position);
            return this;
        }

        public long getNextCycleMetaPosition() {
            return this.nextCycleMetaPosition.getVolatileValue();
        }

        public long getNextRollCycle() {
            return this.nextCycle.getVolatileValue();
        }

        public boolean casNextRollCycle(long rollCycle) {
            return this.nextCycle.compareAndSwapValue(-1L, rollCycle);
        }
    }

    static enum RollFields implements WireKey
    {
        cycle,
        length,
        format,
        timeZone,
        nextCycle,
        nextCycleMetaPosition;

    }

    class Indexing
    implements Marshallable {
        private int indexCount = 131072;
        private int indexSpacing = 64;
        private LongValue index2Index = null;
        private LongValue lastIndex = null;

        Indexing() {
        }

        public void writeMarshallable(@NotNull WireOut wire) {
            this.index2Index = wire.newLongReference();
            this.lastIndex = wire.newLongReference();
            wire.write((WireKey)IndexingFields.indexCount).int32(this.indexCount).write((WireKey)IndexingFields.indexSpacing).int32(this.indexSpacing).write((WireKey)IndexingFields.index2Index).int64forBinding(0L, this.index2Index).write((WireKey)IndexingFields.lastIndex).int64forBinding(-1L, this.lastIndex);
        }

        public void readMarshallable(@NotNull WireIn wire) {
            wire.read((WireKey)IndexingFields.indexCount).int32((Object)this, (o, i) -> {
                o.indexCount = i;
            }).read((WireKey)IndexingFields.indexSpacing).int32((Object)this, (o, i) -> {
                o.indexSpacing = i;
            }).read((WireKey)IndexingFields.index2Index).int64(this.index2Index, (Object)this, (o, i) -> {
                o.index2Index = i;
            }).read((WireKey)IndexingFields.lastIndex).int64(this.lastIndex, (Object)this, (o, i) -> {
                o.lastIndex = i;
            });
        }

        public long incrementLastIndex() {
            return this.lastIndex.addAtomicValue(1L);
        }

        public long getLastIndex() {
            return this.lastIndex.getVolatileValue();
        }
    }

    static enum IndexingFields implements WireKey
    {
        indexCount,
        indexSpacing,
        index2Index,
        lastIndex;

    }

    class Bounds
    implements Marshallable {
        private LongValue writePosition = null;
        private LongValue readPosition = null;

        Bounds() {
        }

        public void writeMarshallable(@NotNull WireOut wire) {
            this.writePosition = wire.newLongReference();
            this.readPosition = wire.newLongReference();
            wire.write((WireKey)BoundsField.writePosition).int64forBinding(0L, this.writePosition).write((WireKey)BoundsField.readPosition).int64forBinding(0L, this.readPosition);
        }

        public void readMarshallable(@NotNull WireIn wire) {
            wire.read((WireKey)BoundsField.writePosition).int64(this.writePosition, (Object)this, (o, i) -> {
                o.writePosition = i;
            }).read((WireKey)BoundsField.readPosition).int64(this.readPosition, (Object)this, (o, i) -> {
                o.readPosition = i;
            });
        }

        public long getReadPosition() {
            return this.readPosition.getVolatileValue();
        }

        public void setReadPosition(long position) {
            this.readPosition.setOrderedValue(position);
        }

        public long getWritePosition() {
            return this.writePosition.getVolatileValue();
        }

        public void setWritePosition(long position) {
            this.writePosition.setOrderedValue(position);
        }

        public void setWritePositionIfGreater(long writePosition) {
            long wp;
            while (writePosition > (wp = SingleChronicleQueueStore.this.writePosition())) {
                if (!this.writePosition.compareAndSwapValue(wp, writePosition)) continue;
                return;
            }
        }
    }

    static enum BoundsField implements WireKey
    {
        writePosition,
        readPosition;

    }

    static enum MetaDataField implements WireKey
    {
        bounds,
        indexing,
        roll;

    }
}

