/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.function.Function;
import net.openhft.chronicle.bytes.MappedFile;
import net.openhft.chronicle.core.pool.ClassAliasPool;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollDateCache;
import net.openhft.chronicle.queue.impl.AbstractChronicleQueue;
import net.openhft.chronicle.queue.impl.WireStore;
import net.openhft.chronicle.queue.impl.WireStorePool;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueStore;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.WiredFile;
import org.jetbrains.annotations.NotNull;

class SingleChronicleQueue
extends AbstractChronicleQueue {
    private final SingleChronicleQueueBuilder builder;
    private final RollCycle cycle;
    private final RollDateCache dateCache;
    private final WireStorePool pool;
    private long firstCycle;

    protected SingleChronicleQueue(SingleChronicleQueueBuilder builder) throws IOException {
        this.cycle = builder.rollCycle();
        this.dateCache = new RollDateCache(this.cycle);
        this.builder = builder;
        this.pool = WireStorePool.withSupplier(this::newStore);
        this.firstCycle = -1L;
    }

    @Override
    protected synchronized WireStore storeForCycle(long cycle) throws IOException {
        return this.pool.acquire(cycle);
    }

    @Override
    protected synchronized void release(@NotNull WireStore store) {
        this.pool.release(store);
    }

    @Override
    protected long cycle() {
        return this.cycle.current();
    }

    @Override
    protected synchronized long firstCycle() {
        if (this.firstCycle != -1L) {
            return this.firstCycle;
        }
        String basePath = this.builder.path().getAbsolutePath();
        File[] files = this.builder.path().listFiles();
        if (files != null && files.length > 0) {
            long firstDate = Long.MAX_VALUE;
            long date = -1L;
            String name = null;
            for (int i = files.length - 1; i >= 0; --i) {
                try {
                    name = files[i].getAbsolutePath();
                    if (!name.endsWith(".chronicle")) continue;
                    name = name.substring(basePath.length() + 1);
                    date = this.dateCache.parseCount(name = name.substring(0, name.indexOf(46)));
                    if (firstDate <= date) continue;
                    firstDate = date;
                    continue;
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            this.firstCycle = firstDate;
        }
        return this.firstCycle;
    }

    @Override
    protected long lastCycle() {
        String basePath = this.builder.path().getAbsolutePath();
        File[] files = this.builder.path().listFiles();
        if (files != null && files.length > 0) {
            long lastDate = Long.MIN_VALUE;
            long date = -1L;
            String name = null;
            for (int i = files.length - 1; i >= 0; --i) {
                try {
                    name = files[i].getAbsolutePath();
                    if (!name.endsWith(".chronicle")) continue;
                    name = name.substring(basePath.length() + 1);
                    date = this.dateCache.parseCount(name = name.substring(0, name.indexOf(46)));
                    if (lastDate >= date) continue;
                    lastDate = date;
                    continue;
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            return lastDate;
        }
        return -1L;
    }

    @Override
    public WireType wireType() {
        throw new UnsupportedOperationException("todo");
    }

    @Override
    public long indexToIndex() {
        throw new UnsupportedOperationException("todo");
    }

    @Override
    public Wire wire() {
        throw new UnsupportedOperationException("todo");
    }

    @Override
    public long newIndex() {
        throw new UnsupportedOperationException("todo");
    }

    protected WireStore newStore(long cycle) {
        try {
            String cycleFormat = this.dateCache.formatFor(cycle);
            File cycleFile = new File(this.builder.path(), cycleFormat + ".chronicle");
            if (!cycleFile.getParentFile().exists()) {
                cycleFile.mkdirs();
            }
            return (WireStore)WiredFile.build((File)cycleFile, file -> MappedFile.mappedFile((File)file, (long)this.builder.blockSize()), (Function)this.builder.wireType(), () -> new SingleChronicleQueueStore(this.builder.rollCycle()), ws -> ((WireStore)ws.delegate()).install(ws.headerStore(), ws.headerLength(), ws.headerCreated(), cycle, ws.wireSupplier(), (Closeable)ws.mappedFile())).delegate();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        ClassAliasPool.CLASS_ALIASES.addAlias(SingleChronicleQueueStore.class, "WireStore");
    }
}

