/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network.connection;

import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import net.openhft.chronicle.network.TCPRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocketAddressSupplier
implements Supplier<SocketAddress> {
    private static final Logger LOG = LoggerFactory.getLogger(SocketAddressSupplier.class);
    private final String name;
    private final List<RemoteAddressSupplier> remoteAddresses = new ArrayList<RemoteAddressSupplier>();
    private final long failoverTimeout = Integer.getInteger("tcp.failover.time", 2000).intValue();
    @Nullable
    private RemoteAddressSupplier current;
    private Iterator<RemoteAddressSupplier> iterator;

    public SocketAddressSupplier(@NotNull String[] connectURIs, String name) {
        this.name = name;
        for (String connectURI : connectURIs) {
            this.remoteAddresses.add(new RemoteAddressSupplier(connectURI));
        }
        assert (this.remoteAddresses.size() > 0);
        this.iterator = this.remoteAddresses.iterator();
        this.next();
    }

    public static SocketAddressSupplier uri(String connectURI) {
        return new SocketAddressSupplier(new String[]{connectURI}, "");
    }

    @NotNull
    public List<RemoteAddressSupplier> all() {
        return this.remoteAddresses;
    }

    public String name() {
        return this.name;
    }

    public void failoverToNextAddress() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("failing over to next address");
        }
        this.next();
    }

    private void next() {
        this.current = this.iterator.hasNext() ? this.iterator.next() : null;
    }

    public void startAtFirstAddress() {
        this.iterator = this.remoteAddresses.iterator();
        this.next();
    }

    public long timeoutMS() {
        return this.failoverTimeout;
    }

    @Override
    @Nullable
    public SocketAddress get() {
        if (this.current == null) {
            return null;
        }
        return this.current.get();
    }

    @NotNull
    public String toString() {
        RemoteAddressSupplier current = this.current;
        if (current == null) {
            return "(none)";
        }
        SocketAddress socketAddress = current.get();
        if (socketAddress == null) {
            return "(none)";
        }
        return socketAddress.toString().replaceAll("0:0:0:0:0:0:0:0", "localhost") + " - " + current.toString();
    }

    private class RemoteAddressSupplier
    implements Supplier<SocketAddress> {
        private final SocketAddress remoteAddress;
        private final String description;

        public RemoteAddressSupplier(String description) {
            this.description = description;
            this.remoteAddress = TCPRegistry.lookup(description);
        }

        @Override
        public SocketAddress get() {
            return this.remoteAddress;
        }

        public String toString() {
            return this.description;
        }
    }
}

