/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.logger.tools;

import java.io.StringWriter;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import net.openhft.chronicle.ChronicleQueueBuilder;
import net.openhft.chronicle.logger.ChronicleLogEvent;
import net.openhft.chronicle.logger.ChronicleLogReader;
import net.openhft.chronicle.logger.tools.ChroniTool;

public final class ChroniGrep {
    public static void main(String[] args) {
        try {
            boolean indexed = false;
            boolean binary = true;
            boolean compressed = true;
            Grep grep = new Grep();
            for (int i = 0; i < args.length - 1; ++i) {
                if ("-t".equals(args[i])) {
                    binary = false;
                    continue;
                }
                if ("-i".equals(args[i])) {
                    indexed = true;
                    continue;
                }
                if ("-u".equals(args[i])) {
                    compressed = false;
                    continue;
                }
                if (i == args.length - 1) continue;
                grep.add(args[i]);
            }
            if (args.length >= 1 && !grep.isEmpty()) {
                ChroniTool.process(indexed ? ChronicleQueueBuilder.indexed((String)args[args.length - 1]).useCompressedObjectSerializer(compressed).build() : ChronicleQueueBuilder.vanilla((String)args[args.length - 1]).useCompressedObjectSerializer(compressed).build(), (ChronicleLogReader)(binary ? new BinaryGrep(grep) : new TextGrep(grep)), false, false);
            } else {
                System.err.format("\nUsage: ChroniGrep [-t|-i|-u] regexp1 ... regexpN path", new Object[0]);
                System.err.format("\n  -u = use uncompressed object serialization, default compressed", new Object[0]);
                System.err.format("\n  -t = text chronicle, default binary", new Object[0]);
                System.err.format("\n  -i = IndexedChronicle, default VanillaChronicle", new Object[0]);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    private ChroniGrep() {
    }

    private static final class TextGrep
    extends ChroniTool.TextProcessor {
        private final Grep grep;
        private final StringWriter writer;

        public TextGrep(Grep grep) {
            this.grep = grep;
            this.writer = new StringWriter();
        }

        public void process(ChronicleLogEvent event) {
            this.writer.getBuffer().setLength(0);
            ChroniTool.asString(event, this.writer).toString();
            if (this.grep.matches(this.writer.getBuffer())) {
                System.out.println(this.writer.getBuffer());
            }
        }
    }

    private static final class BinaryGrep
    extends ChroniTool.BinaryProcessor {
        private final Grep grep;
        private final StringWriter writer;

        public BinaryGrep(Grep grep) {
            this.grep = grep;
            this.writer = new StringWriter();
        }

        public void process(ChronicleLogEvent event) {
            this.writer.getBuffer().setLength(0);
            ChroniTool.asString(event, this.writer).toString();
            if (this.grep.matches(this.writer.getBuffer())) {
                System.out.println(this.writer.getBuffer());
            }
        }
    }

    private static class Grep {
        private Set<String> regexps = new HashSet<String>();

        public void add(String regexp) {
            this.regexps.add(regexp);
        }

        public boolean isEmpty() {
            return this.regexps.isEmpty();
        }

        boolean matches(CharSequence message) {
            for (String regexp : this.regexps) {
                if (!Pattern.matches(regexp, message)) continue;
                return true;
            }
            return false;
        }
    }
}

