/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.logger.tools;

import net.openhft.chronicle.ChronicleQueueBuilder;
import net.openhft.chronicle.logger.ChronicleLogReader;
import net.openhft.chronicle.logger.tools.ChroniTool;
import net.openhft.lang.io.Bytes;

public final class ChroniDump {
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final ChronicleLogReader HEXDUMP = new ChronicleLogReader(){

        public void read(Bytes bytes) {
            StringBuilder result = new StringBuilder();
            long i = 0L;
            while (bytes.remaining() > 0L) {
                byte b;
                long size = bytes.remaining();
                int n = 0;
                while ((long)n < Math.min(16L, size)) {
                    b = bytes.readByte(i * 16L + (long)n);
                    result.append(" ");
                    result.append(HEX_DIGITS[b >>> 4 & 0xF]);
                    result.append(HEX_DIGITS[b & 0xF]);
                    ++n;
                }
                size = bytes.remaining();
                n = 0;
                while ((long)n < 16L - size) {
                    result.append("   ");
                    ++n;
                }
                result.append(" ==> ");
                n = 0;
                while ((long)n < Math.min(16L, size)) {
                    b = bytes.readByte();
                    result.append(b > 32 && b < 126 ? (char)b : (char)'.');
                    ++n;
                }
                result.append('\n');
                ++i;
            }
            System.out.println(result.toString());
        }
    };

    public static void main(String[] args) {
        try {
            boolean indexed = false;
            boolean compressed = true;
            for (int i = 0; i < args.length - 1; ++i) {
                if ("-i".equals(args[i])) {
                    indexed = true;
                    continue;
                }
                if (!"-u".equals(args[i])) continue;
                compressed = false;
            }
            if (args.length >= 1) {
                ChroniTool.process(indexed ? ChronicleQueueBuilder.indexed((String)args[args.length - 1]).useCompressedObjectSerializer(compressed).build() : ChronicleQueueBuilder.vanilla((String)args[args.length - 1]).useCompressedObjectSerializer(compressed).build(), HEXDUMP, false, false);
            } else {
                System.err.format("\nUsage: ChroniDump [-i|-u] path", new Object[0]);
                System.err.format("\n  -u = use uncompressed object serialization, default compressed", new Object[0]);
                System.err.format("\n  -i = IndexedChronicle, default VanillaChronicle", new Object[0]);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    private ChroniDump() {
    }
}

