/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.logger.tools;

import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import net.openhft.chronicle.Chronicle;
import net.openhft.chronicle.ExcerptTailer;
import net.openhft.chronicle.logger.ChronicleLogEvent;
import net.openhft.chronicle.logger.ChronicleLogHelper;
import net.openhft.chronicle.logger.ChronicleLogProcessor;
import net.openhft.chronicle.logger.ChronicleLogReader;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.model.constraints.NotNull;

public final class ChroniTool {
    public static final DateFormat DF = new SimpleDateFormat("yyyy.MM.dd-HH:mm:ss.SSS");
    public static final ChronicleLogReader READER_BINARY = new BinaryProcessor(){

        public void process(ChronicleLogEvent event) {
            System.out.println(ChroniTool.asString(event));
        }
    };
    public static final ChronicleLogReader READER_TEXT = new TextProcessor(){

        public void process(ChronicleLogEvent event) {
            System.out.println(ChroniTool.asString(event));
        }
    };

    public static ChronicleLogReader reader(final ChronicleLogProcessor processor) {
        return new BinaryProcessor(){

            public void process(ChronicleLogEvent event) {
                processor.process(event);
            }
        };
    }

    public static String asString(ChronicleLogEvent event) {
        if (!event.hasArguments()) {
            return String.format("%s|%s|%s|%s|%s\n", DF.format(event.getTimeStamp()), event.getLevel().toString(), event.getThreadName(), event.getLoggerName(), event.getMessage());
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void process(@NotNull Chronicle chronicle, @NotNull ChronicleLogReader reader, boolean waitForData, boolean fromEnd) throws IOException {
        ExcerptTailer tailer = null;
        try {
            ExcerptTailer excerptTailer = tailer = fromEnd ? chronicle.createTailer().toEnd() : chronicle.createTailer();
            while (true) {
                if (tailer.nextIndex()) {
                    reader.read((Bytes)tailer);
                    tailer.finish();
                    continue;
                }
                if (waitForData) {
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException e) {}
                    continue;
                }
                break;
            }
        }
        finally {
            if (tailer != null) {
                tailer.close();
            }
            chronicle.close();
        }
    }

    private ChroniTool() {
    }

    public static abstract class TextProcessor
    implements ChronicleLogReader,
    ChronicleLogProcessor {
        public void read(Bytes bytes) {
            this.process(ChronicleLogHelper.decodeText((Bytes)bytes));
        }
    }

    public static abstract class BinaryProcessor
    implements ChronicleLogReader,
    ChronicleLogProcessor {
        public void read(Bytes bytes) {
            this.process(ChronicleLogHelper.decodeBinary((Bytes)bytes));
        }
    }
}

