/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network.connection;

import net.openhft.chronicle.bytes.IORuntimeException;
import net.openhft.chronicle.core.util.Time;
import net.openhft.chronicle.network.connection.AsyncSubscription;
import net.openhft.chronicle.network.connection.TcpChannelHub;
import net.openhft.chronicle.wire.WireOut;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractAsyncSubscription
implements AsyncSubscription {
    private final long tid;
    @NotNull
    private final TcpChannelHub hub;
    private String csp;
    private String name;

    public AbstractAsyncSubscription(@NotNull TcpChannelHub hub, String csp, String name) {
        this.tid = hub.nextUniqueTransaction(Time.currentTimeMillis());
        this.hub = hub;
        this.csp = csp;
        this.name = name;
    }

    public AbstractAsyncSubscription(@NotNull TcpChannelHub hub, String csp, byte identifier, String name) {
        this.tid = hub.nextUniqueTransaction(Time.currentTimeMillis()) * (long)identifier;
        this.hub = hub;
        this.csp = csp;
        this.name = name;
    }

    @Override
    public long tid() {
        return this.tid;
    }

    @Override
    public void applySubscribe() {
        assert (this.hub.outBytesLock().isHeldByCurrentThread());
        this.hub.writeMetaDataForKnownTID(this.tid(), this.hub.outWire(), this.csp, 0L);
        this.hub.outWire().writeDocument(false, this::onSubscribe);
        try {
            this.hub.writeSocket((WireOut)this.hub.outWire());
        }
        catch (IORuntimeException e) {
            e.printStackTrace();
        }
    }

    public abstract void onSubscribe(WireOut var1);

    @Override
    public void onClose() {
    }

    public String toString() {
        return "AbstractAsyncSubscription{name='" + this.name + '\'' + ", csp='" + this.csp + '\'' + ", tid=" + this.tid + '}';
    }
}

