/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.tree;

import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Supplier;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.util.ThrowingAcceptor;
import net.openhft.chronicle.engine.api.map.MapView;
import net.openhft.chronicle.engine.api.map.SubAsset;
import net.openhft.chronicle.engine.api.pubsub.InvalidSubscriberException;
import net.openhft.chronicle.engine.api.pubsub.Publisher;
import net.openhft.chronicle.engine.api.pubsub.Reference;
import net.openhft.chronicle.engine.api.pubsub.Subscription;
import net.openhft.chronicle.engine.api.pubsub.TopicSubscriber;
import net.openhft.chronicle.engine.api.tree.Asset;
import net.openhft.chronicle.engine.api.tree.AssetNotFoundException;
import net.openhft.chronicle.engine.api.tree.LeafViewFactory;
import net.openhft.chronicle.engine.api.tree.RequestContext;
import net.openhft.chronicle.engine.api.tree.WrappingViewFactory;
import net.openhft.chronicle.engine.map.ObjectKVSSubscription;
import net.openhft.chronicle.engine.pubsub.RemoteReference;
import net.openhft.chronicle.engine.pubsub.RemoteSimpleSubscription;
import net.openhft.chronicle.engine.pubsub.SimpleSubscription;
import net.openhft.chronicle.engine.pubsub.VanillaReference;
import net.openhft.chronicle.engine.pubsub.VanillaSimpleSubscription;
import net.openhft.chronicle.engine.tree.VanillaAsset;
import net.openhft.chronicle.network.connection.TcpChannelHub;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VanillaSubAsset<E>
implements SubAsset<E>,
Closeable,
TopicSubscriber<String, E> {
    @NotNull
    private final VanillaAsset parent;
    private final String name;
    @NotNull
    private final SimpleSubscription<E> subscription;
    @Nullable
    private Reference<E> reference;

    VanillaSubAsset(@NotNull VanillaAsset parent, String name, Class<E> type, Function<Object, E> valueReader) throws AssetNotFoundException {
        this.parent = parent;
        this.name = name;
        TcpChannelHub tcpChannelHub = parent.findView(TcpChannelHub.class);
        if (tcpChannelHub == null) {
            this.reference = new VanillaReference<E>(name, type, parent.acquireView(MapView.class));
            this.subscription = new VanillaSimpleSubscription<E>(this.reference, valueReader);
        } else {
            this.reference = new RemoteReference<E>(tcpChannelHub, type, parent.fullName() + "/" + name);
            this.subscription = new RemoteSimpleSubscription<E>(this.reference, valueReader);
        }
    }

    @Override
    @NotNull
    public Subscription subscription(boolean createIfAbsent) {
        return this.subscription;
    }

    @Override
    @NotNull
    public <V> V getView(Class<V> viewType) {
        if (viewType == Reference.class || viewType == Publisher.class || viewType == Supplier.class) {
            return (V)this.reference;
        }
        if (viewType == Subscription.class || viewType == VanillaSimpleSubscription.class || viewType == ObjectKVSSubscription.class) {
            return (V)this.subscription;
        }
        throw new UnsupportedOperationException("Unable to classify view type " + viewType);
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    @NotNull
    public <V> V acquireView(@NotNull Class<V> viewType, @NotNull RequestContext rc) throws AssetNotFoundException {
        if (viewType == Reference.class || viewType == Supplier.class) {
            return (V)this.reference;
        }
        if (viewType == Publisher.class) {
            if (this.reference == null) {
                return this.acquireViewFor(viewType, rc);
            }
            return (V)this.reference;
        }
        if (viewType == VanillaSimpleSubscription.class || viewType == ObjectKVSSubscription.class) {
            return (V)this.subscription;
        }
        throw new UnsupportedOperationException("todo vClass: " + viewType + ", rc: " + rc);
    }

    @NotNull
    private <V> V acquireViewFor(@NotNull Class<V> viewType, @NotNull RequestContext rc) throws AssetNotFoundException {
        return this.parent.getView(viewType);
    }

    @Override
    public <V> V addView(Class<V> viewType, V view) {
        return view;
    }

    @Override
    public boolean isSubAsset() {
        return true;
    }

    @Override
    public boolean hasChildren() {
        return false;
    }

    public <I> void registerView(Class<I> viewType, I view) {
        throw new UnsupportedOperationException("todo");
    }

    public <W, U> void addWrappingRule(Class<W> viewType, String description, BiPredicate<RequestContext, Asset> predicate, WrappingViewFactory<W, U> factory, Class<U> underlyingType) {
        throw new UnsupportedOperationException("todo");
    }

    public <W, U> void addWrappingRule(Class<W> viewType, String description, WrappingViewFactory<W, U> factory, Class<U> underlyingType) {
        throw new UnsupportedOperationException("todo");
    }

    public <L> void addLeafRule(Class<L> viewType, String description, LeafViewFactory<L> factory) {
        throw new UnsupportedOperationException("todo");
    }

    public void close() {
        this.subscription.close();
    }

    @Override
    public Asset parent() {
        return this.parent;
    }

    @Override
    @NotNull
    public Asset acquireAsset(String childName) throws AssetNotFoundException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <V> boolean hasFactoryFor(Class<V> viewType) {
        return false;
    }

    @Override
    @NotNull
    public Asset getChild(String name) {
        return null;
    }

    @Override
    public void removeChild(String name) {
    }

    @Override
    public void onMessage(@NotNull String name, E e) {
        if (name.equals(this.name)) {
            this.subscription.notifyMessage(e);
        }
    }

    @Override
    public boolean keyedView() {
        return false;
    }

    @Override
    public void forEachChild(ThrowingAcceptor<Asset, InvalidSubscriberException> childAcceptor) throws InvalidSubscriberException {
    }
}

