/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.tree;

import java.util.Objects;
import java.util.Optional;
import net.openhft.chronicle.engine.tree.TopologicalEvent;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireOut;
import org.jetbrains.annotations.NotNull;

public class RemovedAssetEvent
implements TopologicalEvent {
    private String assetName;
    private String name;

    private RemovedAssetEvent(String assetName, String name) {
        this.assetName = assetName;
        this.name = name;
    }

    @NotNull
    public static RemovedAssetEvent of(String assetName, String name) {
        return new RemovedAssetEvent(assetName, name);
    }

    @Override
    public boolean added() {
        return false;
    }

    @Override
    public String assetName() {
        return this.assetName;
    }

    @Override
    public String name() {
        return this.name;
    }

    public int hashCode() {
        return Objects.hash("removal", this.assetName, this.name);
    }

    public boolean equals(Object obj) {
        return Optional.ofNullable(obj).filter(o -> o instanceof RemovedAssetEvent).map(o -> (RemovedAssetEvent)o).filter(e -> Objects.equals(this.assetName, e.assetName)).filter(e -> Objects.equals(this.name, e.name)).isPresent();
    }

    @NotNull
    public String toString() {
        return "RemovedAssetEvent{assetName='" + this.assetName + '\'' + ", name='" + this.name + '\'' + '}';
    }

    public void readMarshallable(@NotNull WireIn wire) throws IllegalStateException {
        wire.read((WireKey)TopologicalEvent.TopologicalFields.assetName).text(s -> {
            this.assetName = s;
        });
        wire.read((WireKey)TopologicalEvent.TopologicalFields.name).text(s -> {
            this.name = s;
        });
    }

    public void writeMarshallable(@NotNull WireOut wire) {
        wire.write((WireKey)TopologicalEvent.TopologicalFields.assetName).text((CharSequence)this.assetName);
        wire.write((WireKey)TopologicalEvent.TopologicalFields.name).object((Object)this.name);
    }
}

