/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.set;

import java.util.AbstractCollection;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import net.openhft.chronicle.engine.api.map.KeyValueStore;
import net.openhft.chronicle.engine.api.map.MapView;
import net.openhft.chronicle.engine.api.set.KeySetView;
import net.openhft.chronicle.engine.api.tree.Asset;
import net.openhft.chronicle.engine.api.tree.RequestContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VanillaKeySetView<K, V>
extends AbstractCollection<K>
implements KeySetView<K> {
    private final Asset asset;
    private final MapView<K, V, V> kvMapView;

    public VanillaKeySetView(RequestContext context, Asset asset, MapView<K, V, V> kvMapView) {
        this.asset = asset;
        this.kvMapView = kvMapView;
    }

    @Override
    public int size() {
        return this.kvMapView.size();
    }

    @Override
    public boolean contains(Object o) {
        return this.kvMapView.containsKey(o);
    }

    @Override
    @NotNull
    public Iterator<K> iterator() {
        return ((KeyValueStore)this.kvMapView.underlying()).keySetIterator();
    }

    @Override
    public int hashCode() {
        int h = 0;
        for (K k : this) {
            h += Objects.hashCode(k);
        }
        return h;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Set)) {
            return false;
        }
        Set set = (Set)obj;
        if (set.size() != this.size()) {
            return false;
        }
        for (Object k : set) {
            if (k != null && this.contains(k)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean add(K k) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        return ((KeyValueStore)this.kvMapView.underlying()).remove(o);
    }

    @Override
    public Asset asset() {
        return this.asset;
    }

    @Override
    @Nullable
    public MapView<K, ?, ?> underlying() {
        return this.kvMapView;
    }
}

