/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.server.internal;

import java.util.Queue;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import net.openhft.chronicle.engine.api.pubsub.InvalidSubscriberException;
import net.openhft.chronicle.engine.api.pubsub.Publisher;
import net.openhft.chronicle.engine.api.pubsub.Subscriber;
import net.openhft.chronicle.engine.server.internal.AbstractHandler;
import net.openhft.chronicle.engine.server.internal.PublisherHandler;
import net.openhft.chronicle.engine.server.internal.WireAdapter;
import net.openhft.chronicle.network.connection.CoreFields;
import net.openhft.chronicle.wire.ParameterizeWireKey;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireOut;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TopologyHandler<E>
extends AbstractHandler {
    private final StringBuilder eventName = new StringBuilder();
    private Queue<Consumer<Wire>> publisher;
    private Publisher<E> view;
    @Nullable
    private Function<ValueIn, E> wireToE;
    private final BiConsumer<WireIn, Long> dataConsumer = new BiConsumer<WireIn, Long>(){

        @Override
        public void accept(@NotNull WireIn inWire, final Long inputTid) {
            TopologyHandler.this.eventName.setLength(0);
            ValueIn valueIn = inWire.readEventName(TopologyHandler.this.eventName);
            if (PublisherHandler.EventId.registerSubscriber.contentEquals(TopologyHandler.this.eventName)) {
                Subscriber listener = new Subscriber(){

                    public void onMessage(Object message) throws InvalidSubscriberException {
                        TopologyHandler.this.publisher.add(publish -> {
                            publish.writeDocument(true, wire -> wire.writeEventName((WireKey)CoreFields.tid).int64(inputTid.longValue()));
                            publish.writeNotReadyDocument(false, wire -> wire.writeEventName((WireKey)CoreFields.reply).marshallable(m -> m.write((WireKey)Params.message).object(message)));
                        });
                    }
                };
                boolean bootstrap = true;
                valueIn.marshallable(m -> TopologyHandler.this.view.registerSubscriber(bootstrap, listener));
                return;
            }
            TopologyHandler.this.outWire.writeDocument(true, wire -> TopologyHandler.this.outWire.writeEventName((WireKey)CoreFields.tid).int64(inputTid.longValue()));
            TopologyHandler.this.writeData(inWire.bytes(), out -> {
                if (PublisherHandler.EventId.publish.contentEquals(TopologyHandler.this.eventName)) {
                    valueIn.marshallable(wire -> {
                        Params[] params = (Params[])PublisherHandler.EventId.publish.params();
                        Object message = TopologyHandler.this.wireToE.apply(wire.read((WireKey)params[1]));
                        AbstractHandler.nullCheck(message);
                        TopologyHandler.this.view.publish(message);
                    });
                }
            });
        }
    };

    void process(@NotNull Wire inWire, Queue<Consumer<Wire>> publisher, long tid, Publisher<E> view, Wire outWire, @NotNull WireAdapter<?, E> wireAdapter) {
        this.setOutWire((WireOut)outWire);
        this.outWire = outWire;
        this.publisher = publisher;
        this.view = view;
        this.wireToE = wireAdapter.wireToValue();
        this.dataConsumer.accept((WireIn)inWire, tid);
    }

    public static enum EventId implements ParameterizeWireKey
    {
        publish(new WireKey[0]),
        onEndOfSubscription(new WireKey[0]),
        registerTopicSubscriber((WireKey[])new PublisherHandler.Params[]{PublisherHandler.Params.message});

        private final WireKey[] params;

        private <P extends WireKey> EventId(P ... params) {
            this.params = params;
        }

        @NotNull
        public <P extends WireKey> P[] params() {
            return this.params;
        }
    }

    public static enum Params implements WireKey
    {
        message;

    }
}

