/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.server.internal;

import java.util.function.BiConsumer;
import java.util.function.Function;
import net.openhft.chronicle.engine.api.pubsub.InvalidSubscriberException;
import net.openhft.chronicle.engine.api.pubsub.TopicPublisher;
import net.openhft.chronicle.engine.api.pubsub.TopicSubscriber;
import net.openhft.chronicle.engine.server.internal.AbstractHandler;
import net.openhft.chronicle.engine.server.internal.WireAdapter;
import net.openhft.chronicle.network.connection.CoreFields;
import net.openhft.chronicle.network.connection.WireOutPublisher;
import net.openhft.chronicle.wire.ParameterizeWireKey;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireOut;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TopicPublisherHandler<T, M>
extends AbstractHandler {
    private final StringBuilder eventName = new StringBuilder();
    private WireOutPublisher publisher;
    private TopicPublisher<T, M> view;
    @Nullable
    private Function<ValueIn, T> wireToT;
    @Nullable
    private Function<ValueIn, M> wireToM;
    private final BiConsumer<WireIn, Long> dataConsumer = new BiConsumer<WireIn, Long>(){

        @Override
        public void accept(@NotNull WireIn inWire, final Long inputTid) {
            TopicPublisherHandler.this.eventName.setLength(0);
            ValueIn valueIn = inWire.readEventName(TopicPublisherHandler.this.eventName);
            if (EventId.registerTopicSubscriber.contentEquals(TopicPublisherHandler.this.eventName)) {
                TopicSubscriber listener = new TopicSubscriber(){

                    public void onMessage(Object topic, Object message) throws InvalidSubscriberException {
                        TopicPublisherHandler.this.publisher.add(publish -> {
                            publish.writeDocument(true, wire -> wire.writeEventName((WireKey)CoreFields.tid).int64(inputTid.longValue()));
                            publish.writeNotReadyDocument(false, wire -> wire.writeEventName((WireKey)CoreFields.reply).marshallable(m -> {
                                m.write(() -> "topic").object(topic);
                                m.write(() -> "message").object(message);
                            }));
                        });
                    }

                    @Override
                    public void onEndOfSubscription() {
                        TopicPublisherHandler.this.publisher.add(publish -> {
                            publish.writeDocument(true, wire -> wire.writeEventName((WireKey)CoreFields.tid).int64(inputTid.longValue()));
                            publish.writeNotReadyDocument(false, wire -> wire.writeEventName((WireKey)EventId.onEndOfSubscription).text((CharSequence)""));
                        });
                    }
                };
                valueIn.marshallable(m -> TopicPublisherHandler.this.view.registerTopicSubscriber(listener));
                return;
            }
            if (EventId.publish.contentEquals(TopicPublisherHandler.this.eventName)) {
                valueIn.marshallable(wire -> {
                    Params[] params = (Params[])EventId.publish.params();
                    Object topic = TopicPublisherHandler.this.wireToT.apply(wire.read((WireKey)params[0]));
                    Object message = TopicPublisherHandler.this.wireToM.apply(wire.read((WireKey)params[1]));
                    AbstractHandler.nullCheck(topic);
                    AbstractHandler.nullCheck(message);
                    TopicPublisherHandler.this.view.publish(topic, message);
                });
            }
        }
    };

    void process(@NotNull WireIn inWire, WireOutPublisher publisher, long tid, Wire outWire, TopicPublisher view, @NotNull WireAdapter wireAdapter) {
        this.setOutWire((WireOut)outWire);
        this.view = view;
        this.publisher = publisher;
        this.wireToT = wireAdapter.wireToKey();
        this.wireToM = wireAdapter.wireToValue();
        this.dataConsumer.accept(inWire, tid);
    }

    public static enum EventId implements ParameterizeWireKey
    {
        publish((WireKey[])new Params[]{Params.topic, Params.message}),
        onEndOfSubscription(new WireKey[0]),
        registerTopicSubscriber((WireKey[])new Params[]{Params.topic, Params.message});

        private final WireKey[] params;

        private <P extends WireKey> EventId(P ... params) {
            this.params = params;
        }

        @NotNull
        public <P extends WireKey> P[] params() {
            return this.params;
        }
    }

    public static enum Params implements WireKey
    {
        topic,
        message;

    }
}

