/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.server.internal;

import java.util.function.BiConsumer;
import net.openhft.chronicle.engine.server.internal.AbstractHandler;
import net.openhft.chronicle.network.api.session.SessionDetailsProvider;
import net.openhft.chronicle.network.connection.CoreFields;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireOut;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SystemHandler
extends AbstractHandler {
    private final StringBuilder eventName = new StringBuilder();
    private SessionDetailsProvider sessionDetails;
    @Nullable
    private final BiConsumer<WireIn, Long> dataConsumer = (inWire, tid) -> {
        this.eventName.setLength(0);
        ValueIn valueIn = inWire.readEventName(this.eventName);
        if (EventId.userid.contentEquals(this.eventName)) {
            this.sessionDetails.setUserId(valueIn.text());
            return;
        }
        this.outWire.writeDocument(true, wire -> this.outWire.writeEventName((WireKey)CoreFields.tid).int64(tid.longValue()));
        this.writeData(inWire.bytes(), out -> {
            if (EventId.heartbeat.contentEquals(this.eventName)) {
                this.outWire.write((WireKey)EventId.heartbeatReply).int64(valueIn.int64());
                return;
            }
        });
    };

    void process(@NotNull WireIn inWire, @NotNull WireOut outWire, long tid, @NotNull SessionDetailsProvider sessionDetails) {
        this.sessionDetails = sessionDetails;
        this.setOutWire(outWire);
        this.dataConsumer.accept(inWire, tid);
    }

    public static enum EventId implements WireKey
    {
        heartbeat,
        heartbeatReply,
        userid;

    }
}

