/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.server.internal;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import net.openhft.chronicle.engine.api.pubsub.InvalidSubscriberException;
import net.openhft.chronicle.engine.api.pubsub.Subscriber;
import net.openhft.chronicle.engine.api.pubsub.Subscription;
import net.openhft.chronicle.engine.api.tree.AssetNotFoundException;
import net.openhft.chronicle.engine.api.tree.AssetTree;
import net.openhft.chronicle.engine.api.tree.RequestContext;
import net.openhft.chronicle.engine.server.internal.AbstractHandler;
import net.openhft.chronicle.engine.server.internal.ObjectKVSubscriptionHandler;
import net.openhft.chronicle.network.connection.CoreFields;
import net.openhft.chronicle.network.connection.WireOutPublisher;
import net.openhft.chronicle.wire.ParameterizeWireKey;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireOut;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionHandler<T extends Subscription>
extends AbstractHandler {
    private static final Logger LOG = LoggerFactory.getLogger(SubscriptionHandler.class);
    final StringBuilder eventName = new StringBuilder();
    final Map<Long, Object> tidToListener = new ConcurrentHashMap<Long, Object>();
    protected Wire outWire;
    protected T subscription;
    protected RequestContext requestContext;
    protected WireOutPublisher publisher;
    protected AssetTree assetTree;

    protected boolean after(StringBuilder eventName) {
        if (SubscriptionEventID.topicSubscriberCount.contentEquals(eventName)) {
            this.outWire.writeEventName((WireKey)CoreFields.reply).int8((long)this.subscription.topicSubscriberCount());
            return true;
        }
        if (SubscriptionEventID.keySubscriberCount.contentEquals(eventName)) {
            this.outWire.writeEventName((WireKey)CoreFields.reply).int8((long)this.subscription.keySubscriberCount());
            return true;
        }
        if (SubscriptionEventID.entrySubscriberCount.contentEquals(eventName)) {
            this.outWire.writeEventName((WireKey)CoreFields.reply).int8((long)this.subscription.entrySubscriberCount());
        }
        return false;
    }

    protected boolean before(Long tid, ValueIn valueIn) throws AssetNotFoundException {
        if (SubscriptionEventID.registerSubscriber.contentEquals(this.eventName)) {
            Class subscriptionType = valueIn.typeLiteral();
            LocalSubscriber listener = new LocalSubscriber(tid);
            this.tidToListener.put(tid, listener);
            RequestContext rc = this.requestContext.clone().type(subscriptionType);
            this.assetTree.acquireSubscription(rc).registerSubscriber(rc, listener);
            return true;
        }
        if (SubscriptionEventID.unregisterSubscriber.contentEquals(this.eventName)) {
            Subscriber listener = (Subscriber)this.tidToListener.remove(tid);
            if (listener == null) {
                LOG.warn("No subscriber to present to unregisterSubscriber (" + tid + ")");
                return true;
            }
            this.assetTree.unregisterSubscriber(this.requestContext.name(), listener);
            return true;
        }
        return false;
    }

    class LocalSubscriber
    implements Subscriber<Object> {
        private final Long tid;

        LocalSubscriber(Long tid) {
            this.tid = tid;
        }

        @Override
        public void onMessage(Object e) throws InvalidSubscriberException {
            Consumer<WireOut> toPublish = publish -> {
                publish.writeDocument(true, wire -> wire.writeEventName((WireKey)CoreFields.tid).int64(this.tid.longValue()));
                publish.writeNotReadyDocument(false, wire -> wire.write((WireKey)CoreFields.reply).object(e));
            };
            SubscriptionHandler.this.publisher.add(toPublish);
        }

        @Override
        public void onEndOfSubscription() {
            if (!SubscriptionHandler.this.publisher.isClosed()) {
                Consumer<WireOut> toPublish = publish -> {
                    publish.writeDocument(true, wire -> wire.writeEventName((WireKey)CoreFields.tid).int64(this.tid.longValue()));
                    publish.writeDocument(false, wire -> wire.writeEventName((WireKey)ObjectKVSubscriptionHandler.EventId.onEndOfSubscription).text((CharSequence)""));
                };
                SubscriptionHandler.this.publisher.add(toPublish);
            }
        }
    }

    public static enum SubscriptionEventID implements ParameterizeWireKey
    {
        registerSubscriber(new WireKey[0]),
        unregisterSubscriber(new WireKey[0]),
        keySubscriberCount(new WireKey[0]),
        entrySubscriberCount(new WireKey[0]),
        topicSubscriberCount(new WireKey[0]);

        private final WireKey[] params;

        private <P extends WireKey> SubscriptionEventID(P ... params) {
            this.params = params;
        }

        @NotNull
        public <P extends WireKey> P[] params() {
            return this.params;
        }
    }
}

