/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.server;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.engine.api.tree.AssetTree;
import net.openhft.chronicle.engine.map.ChronicleMapKeyValueStore;
import net.openhft.chronicle.engine.server.internal.EngineWireHandler;
import net.openhft.chronicle.network.AcceptorEventHandler;
import net.openhft.chronicle.network.VanillaSessionDetails;
import net.openhft.chronicle.threads.Threads;
import net.openhft.chronicle.threads.api.EventHandler;
import net.openhft.chronicle.threads.api.EventLoop;
import net.openhft.chronicle.wire.WireType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerEndpoint
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChronicleMapKeyValueStore.class);
    @Nullable
    private EventLoop eg;
    @Nullable
    private AcceptorEventHandler eah;
    @NotNull
    private AtomicBoolean isClosed = new AtomicBoolean();

    public ServerEndpoint(String hostPortDescription, @NotNull AssetTree assetTree, WireType wire) throws IOException {
        this.eg = assetTree.root().acquireView(EventLoop.class);
        Threads.withThreadGroup((ThreadGroup)assetTree.root().getView(ThreadGroup.class), () -> {
            this.start(hostPortDescription, assetTree, wire);
            return null;
        });
    }

    @Nullable
    public AcceptorEventHandler start(String hostPortDescription, @NotNull AssetTree asset, WireType wireType) throws IOException {
        this.eg.start();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.info("starting server=" + hostPortDescription);
        }
        AcceptorEventHandler eah = new AcceptorEventHandler(hostPortDescription, () -> new EngineWireHandler(wireType, asset), VanillaSessionDetails::new);
        this.eg.addHandler((EventHandler)eah);
        this.eah = eah;
        return eah;
    }

    public void stop() {
        if (this.eg != null) {
            this.eg.stop();
        }
    }

    public void close() {
        this.isClosed.set(true);
        this.stop();
        Closeable.closeQuietly((Object)this.eg);
        this.eg = null;
        Closeable.closeQuietly((Object)this.eah);
        this.eah = null;
    }
}

