/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.pubsub;

import net.openhft.chronicle.engine.api.map.MapView;
import net.openhft.chronicle.engine.api.pubsub.Reference;
import net.openhft.chronicle.engine.api.pubsub.Subscriber;
import net.openhft.chronicle.engine.api.pubsub.Subscription;
import net.openhft.chronicle.engine.api.tree.Asset;
import net.openhft.chronicle.engine.api.tree.AssetNotFoundException;
import net.openhft.chronicle.engine.api.tree.RequestContext;
import net.openhft.chronicle.engine.api.tree.View;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VanillaReference<E>
implements Reference<E>,
View {
    private final String name;
    private final Class<E> eClass;
    private final MapView<String, E, E> underlyingMap;

    public VanillaReference(@NotNull RequestContext context, Asset asset, MapView<String, E, E> underlying) throws AssetNotFoundException {
        this(context.name(), context.type(), underlying);
    }

    public VanillaReference(String name, Class<E> type, MapView<String, E, E> mapView) {
        this.name = name;
        this.eClass = type;
        this.underlyingMap = mapView;
    }

    @Override
    public void set(E event) {
        this.underlyingMap.set(this.name, event);
    }

    @Override
    @Nullable
    public E get() {
        return (E)this.underlyingMap.get((Object)this.name);
    }

    @Override
    public void remove() {
        this.underlyingMap.remove(this.name);
    }

    @Override
    public void registerSubscriber(boolean bootstrap, Subscriber<E> subscriber) throws AssetNotFoundException {
        this.underlyingMap.asset().getChild(this.name).subscription(true).registerSubscriber(RequestContext.requestContext().bootstrap(bootstrap).type(this.eClass), subscriber);
    }

    @Override
    public void unregisterSubscriber(Subscriber<E> subscriber) {
        Subscription subscription = this.underlyingMap.asset().getChild(this.name).subscription(false);
        if (subscription != null) {
            subscription.unregisterSubscriber(subscriber);
        }
    }

    @Override
    public int subscriberCount() {
        Subscription subscription = this.underlyingMap.asset().getChild(this.name).subscription(false);
        if (subscription != null) {
            return subscription.subscriberCount();
        }
        return 0;
    }

    @Override
    public Class getType() {
        return this.eClass;
    }
}

