/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.pubsub;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.openhft.chronicle.core.pool.ClassAliasPool;
import net.openhft.chronicle.core.util.SerializableBiFunction;
import net.openhft.chronicle.core.util.SerializableFunction;
import net.openhft.chronicle.engine.api.pubsub.InvalidSubscriberException;
import net.openhft.chronicle.engine.api.pubsub.Reference;
import net.openhft.chronicle.engine.api.pubsub.Subscriber;
import net.openhft.chronicle.engine.api.tree.Asset;
import net.openhft.chronicle.engine.api.tree.AssetNotFoundException;
import net.openhft.chronicle.engine.api.tree.RequestContext;
import net.openhft.chronicle.engine.server.internal.ReferenceHandler;
import net.openhft.chronicle.network.connection.AbstractAsyncSubscription;
import net.openhft.chronicle.network.connection.AbstractStatelessClient;
import net.openhft.chronicle.network.connection.CoreFields;
import net.openhft.chronicle.network.connection.TcpChannelHub;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.Wires;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteReference<E>
extends AbstractStatelessClient<ReferenceHandler.EventId>
implements Reference<E> {
    private static final Logger LOG = LoggerFactory.getLogger(ReferenceHandler.class);
    private final Class<E> messageClass;
    protected final Map<Object, Long> subscribersToTid = new ConcurrentHashMap<Object, Long>();

    public RemoteReference(RequestContext requestContext, Asset asset) {
        this(asset.findView(TcpChannelHub.class), requestContext.messageType(), asset.fullName());
    }

    public RemoteReference(TcpChannelHub hub, Class<E> messageClass, String fullName) throws AssetNotFoundException {
        super(hub, 0L, RemoteReference.toUri(fullName, messageClass));
        this.messageClass = messageClass;
    }

    private static String toUri(String fullName, Class messageClass) {
        StringBuilder uri = new StringBuilder("/" + fullName + "?view=reference");
        if (messageClass != String.class) {
            uri.append("&messageType=").append(ClassAliasPool.CLASS_ALIASES.nameFor(messageClass));
        }
        return uri.toString();
    }

    @Override
    public void set(E event) {
        this.checkEvent(event);
        this.sendEventAsync((WireKey)ReferenceHandler.EventId.set, valueOut -> valueOut.object(event), true);
    }

    @Override
    public E get() {
        return this.proxyReturnTypedObject(ReferenceHandler.EventId.get, null, this.messageClass, null);
    }

    @Override
    public E getAndSet(E e) {
        return this.proxyReturnTypedObject(ReferenceHandler.EventId.getAndSet, null, this.messageClass, e);
    }

    @Override
    public void remove() {
        this.sendEventAsync((WireKey)ReferenceHandler.EventId.remove, null, true);
    }

    @Override
    public E getAndRemove() {
        return this.proxyReturnTypedObject(ReferenceHandler.EventId.getAndRemove, null, this.messageClass, null);
    }

    @Override
    public void unregisterSubscriber(Subscriber<E> subscriber) {
        Long subscriberTid = this.subscribersToTid.remove(subscriber);
        if (subscriberTid != null) {
            this.sendEventAsync((WireKey)ReferenceHandler.EventId.unregisterSubscriber, valueOut -> valueOut.int64(subscriberTid.longValue()), false);
        } else {
            LOG.warn("No subscriber to unsubscribe");
        }
    }

    @Override
    public int subscriberCount() {
        return this.proxyReturnInt((WireKey)ReferenceHandler.EventId.countSubscribers);
    }

    @Override
    public void registerSubscriber(boolean bootstrap, final @NotNull Subscriber subscriber) throws AssetNotFoundException {
        if (this.hub.outBytesLock().isHeldByCurrentThread()) {
            throw new IllegalStateException("Cannot view map while debugging");
        }
        AbstractAsyncSubscription asyncSubscription = new AbstractAsyncSubscription(this.hub, this.csp + "&bootstrap=" + bootstrap, "Remote Ref registerSubscriber"){

            @Override
            public void onSubscribe(@NotNull WireOut wireOut) {
                RemoteReference.this.subscribersToTid.put(subscriber, this.tid());
                wireOut.writeEventName((WireKey)ReferenceHandler.EventId.registerSubscriber).text((CharSequence)"");
            }

            @Override
            public void onConsumer(@NotNull WireIn w) {
                w.readDocument(null, d -> {
                    StringBuilder eventname = Wires.acquireStringBuilder();
                    ValueIn valueIn = d.readEventName(eventname);
                    if (ReferenceHandler.EventId.onEndOfSubscription.contentEquals(eventname)) {
                        subscriber.onEndOfSubscription();
                        RemoteReference.this.hub.unsubscribe(this.tid());
                    } else if (CoreFields.reply.contentEquals(eventname)) {
                        valueIn.marshallable(m -> {
                            Object message = m.read(() -> "message").object(RemoteReference.this.messageClass);
                            RemoteReference.this.onEvent(message, subscriber);
                        });
                    }
                });
            }
        };
        this.hub.subscribe(asyncSubscription);
    }

    private void onEvent(@Nullable E message, @NotNull Subscriber<E> subscriber) {
        try {
            if (message != null) {
                subscriber.onMessage(message);
            }
        }
        catch (InvalidSubscriberException invalidSubscriberException) {
            // empty catch block
        }
    }

    private void checkEvent(@Nullable Object key) {
        if (key == null) {
            throw new NullPointerException("event can not be null");
        }
    }

    @Override
    public <R> R applyTo(@NotNull SerializableFunction<E, R> function) {
        return this.applyTo((SerializableBiFunction & Serializable)(x, $) -> function.apply(x), null);
    }

    @Override
    public void asyncUpdate(@NotNull SerializableFunction<E, E> updateFunction) {
        this.asyncUpdate((SerializableBiFunction & Serializable)(x, $) -> updateFunction.apply(x), null);
    }

    @Override
    public <R> R syncUpdate(@NotNull SerializableFunction<E, E> updateFunction, @NotNull SerializableFunction<E, R> returnFunction) {
        return this.syncUpdate((SerializableBiFunction & Serializable)(x, $) -> updateFunction.apply(x), null, (SerializableBiFunction & Serializable)(x, $) -> returnFunction.apply(x), null);
    }

    @Override
    public <T, R> R applyTo(@NotNull SerializableBiFunction<E, T, R> function, T argument) {
        return (R)super.proxyReturnTypedObject(ReferenceHandler.EventId.applyTo2, null, Object.class, function, argument);
    }

    @Override
    public <T> void asyncUpdate(@NotNull SerializableBiFunction<E, T, E> updateFunction, T argument) {
        this.sendEventAsync((WireKey)ReferenceHandler.EventId.update2, RemoteReference.toParameters(ReferenceHandler.EventId.update2, updateFunction, argument), true);
    }

    @Override
    public <UT, RT, R> R syncUpdate(@NotNull SerializableBiFunction<E, UT, E> updateFunction, @Nullable UT updateArgument, @NotNull SerializableBiFunction<E, RT, R> returnFunction, @Nullable RT returnArgument) {
        return (R)this.proxyReturnTypedObject(ReferenceHandler.EventId.update4, null, Object.class, updateFunction, updateArgument, returnFunction, returnArgument);
    }
}

