/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.map;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.engine.api.map.KeyValueStore;
import net.openhft.chronicle.engine.api.map.MapEvent;
import net.openhft.chronicle.engine.api.map.MapView;
import net.openhft.chronicle.engine.api.pubsub.InvalidSubscriberException;
import net.openhft.chronicle.engine.api.pubsub.Reference;
import net.openhft.chronicle.engine.api.pubsub.Subscriber;
import net.openhft.chronicle.engine.api.pubsub.TopicSubscriber;
import net.openhft.chronicle.engine.api.set.EntrySetView;
import net.openhft.chronicle.engine.api.set.KeySetView;
import net.openhft.chronicle.engine.api.tree.Asset;
import net.openhft.chronicle.engine.api.tree.RequestContext;
import net.openhft.chronicle.engine.map.KVSSubscription;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VanillaMapView<K, MV, V>
implements MapView<K, MV, V> {
    private final boolean putReturnsNull;
    private final boolean removeReturnsNull;
    private final Class keyClass;
    private final Class valueType;
    private Asset asset;
    private KeyValueStore<K, MV, V> kvStore;
    private AbstractCollection<V> values;

    public VanillaMapView(@NotNull RequestContext context, Asset asset, KeyValueStore<K, MV, V> kvStore) {
        this(context.keyType(), context.valueType(), asset, kvStore, context.putReturnsNull() != Boolean.FALSE, context.removeReturnsNull() != Boolean.FALSE);
    }

    public VanillaMapView(Class keyClass, Class valueType, Asset asset, KeyValueStore<K, MV, V> kvStore, boolean putReturnsNull, boolean removeReturnsNull) {
        this.keyClass = keyClass;
        this.valueType = valueType;
        this.asset = asset;
        this.kvStore = kvStore;
        this.putReturnsNull = putReturnsNull;
        this.removeReturnsNull = removeReturnsNull;
    }

    @Override
    public Class<K> keyType() {
        return this.keyClass;
    }

    @Override
    public Class<V> valueType() {
        return this.valueType;
    }

    @Override
    public V getUsing(K key, MV usingValue) {
        return this.kvStore.getUsing(key, usingValue);
    }

    @Override
    public Set<K> keySet() {
        return this.asset.acquireView(KeySetView.class);
    }

    @Override
    @NotNull
    public Collection<V> values() {
        if (this.values == null) {
            this.values = new AbstractCollection<V>(){

                @Override
                public Iterator<V> iterator() {
                    return new Iterator<V>(){
                        private Iterator<Map.Entry<K, V>> i;
                        {
                            this.i = VanillaMapView.this.entrySet().iterator();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.i.hasNext();
                        }

                        @Override
                        public V next() {
                            return this.i.next().getValue();
                        }

                        @Override
                        public void remove() {
                            this.i.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return VanillaMapView.this.size();
                }

                @Override
                public boolean isEmpty() {
                    return VanillaMapView.this.isEmpty();
                }

                @Override
                public void clear() {
                    VanillaMapView.this.clear();
                }

                @Override
                public boolean contains(Object v) {
                    return VanillaMapView.this.containsValue(v);
                }
            };
        }
        return this.values;
    }

    @Override
    public boolean isEmpty() {
        return this.longSize() == 0L;
    }

    @Override
    public boolean containsKey(Object key) {
        this.checkKey(key);
        return this.keyClass.isInstance(key) && this.kvStore.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        this.checkValue(value);
        try {
            for (int i = 0; i < this.kvStore.segments(); ++i) {
                this.kvStore.entriesFor(i, e -> {
                    if (BytesUtil.equals(e.value(), (Object)value)) {
                        throw new InvalidSubscriberException();
                    }
                });
            }
            return false;
        }
        catch (InvalidSubscriberException e2) {
            return true;
        }
    }

    protected void checkKey(@Nullable Object key) {
        if (key == null) {
            throw new NullPointerException("key can not be null");
        }
    }

    protected void checkValue(@Nullable Object value) {
        if (value == null) {
            throw new NullPointerException("value can not be null");
        }
    }

    @Override
    public Asset asset() {
        return this.asset;
    }

    @Override
    public KeyValueStore<K, MV, V> underlying() {
        return this.kvStore;
    }

    @Override
    @Nullable
    public V get(Object key) {
        this.checkKey(key);
        return this.kvStore.isKeyType(key) ? (V)this.kvStore.getUsing(key, null) : null;
    }

    @Override
    @Nullable
    public V put(K key, V value) {
        this.checkKey(key);
        this.checkValue(value);
        if (this.putReturnsNull) {
            this.kvStore.put(key, value);
            return null;
        }
        return this.kvStore.getAndPut(key, value);
    }

    @Override
    public void set(K key, V value) {
        this.checkKey(key);
        this.checkValue(value);
        this.kvStore.put(key, value);
    }

    @Override
    @Nullable
    public V remove(Object key) {
        this.checkKey(key);
        if (!this.kvStore.isKeyType(key)) {
            return null;
        }
        Object key2 = key;
        if (this.removeReturnsNull) {
            this.kvStore.remove(key2);
            return null;
        }
        return this.kvStore.getAndRemove(key2);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public long longSize() {
        return this.kvStore.longSize();
    }

    @Override
    public V getAndPut(K key, V value) {
        return this.kvStore.getAndPut(key, value);
    }

    @Override
    public V getAndRemove(K key) {
        return this.kvStore.getAndRemove(key);
    }

    @Override
    @NotNull
    @net.openhft.chronicle.core.annotation.NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        return this.asset.acquireView(EntrySetView.class);
    }

    @Override
    public void clear() {
        this.kvStore.clear();
    }

    @Override
    @Nullable
    public V putIfAbsent(@net.openhft.chronicle.core.annotation.NotNull K key, V value) {
        this.checkKey(key);
        this.checkValue(value);
        return this.kvStore.putIfAbsent(key, value);
    }

    @Override
    public boolean remove(@net.openhft.chronicle.core.annotation.NotNull Object key, Object value) {
        this.checkKey(key);
        this.checkValue(value);
        return this.kvStore.isKeyType(key) && this.kvStore.removeIfEqual(key, value);
    }

    @Override
    public boolean replace(@net.openhft.chronicle.core.annotation.NotNull K key, @net.openhft.chronicle.core.annotation.NotNull V oldValue, @net.openhft.chronicle.core.annotation.NotNull V newValue) {
        this.checkKey(key);
        this.checkValue(oldValue);
        this.checkValue(newValue);
        return this.kvStore.replaceIfEqual(key, oldValue, newValue);
    }

    @Override
    @Nullable
    public V replace(@net.openhft.chronicle.core.annotation.NotNull K key, @net.openhft.chronicle.core.annotation.NotNull V value) {
        this.checkKey(key);
        this.checkValue(value);
        return this.kvStore.replace(key, value);
    }

    @Override
    public void registerTopicSubscriber(TopicSubscriber<K, V> topicSubscriber) {
        KVSSubscription subscription = (KVSSubscription)this.asset.subscription(true);
        subscription.registerTopicSubscriber(RequestContext.requestContext().bootstrap(true).type(this.keyClass).type2(this.valueType), topicSubscriber);
    }

    @Override
    public void registerKeySubscriber(Subscriber<K> subscriber) {
        KVSSubscription subscription = (KVSSubscription)this.asset.subscription(true);
        subscription.registerKeySubscriber(RequestContext.requestContext().bootstrap(true).type(this.keyClass), subscriber);
    }

    @Override
    public void registerSubscriber(Subscriber<MapEvent<K, V>> subscriber) {
        KVSSubscription subscription = (KVSSubscription)this.asset.subscription(true);
        subscription.registerSubscriber(RequestContext.requestContext().bootstrap(true).type(MapEvent.class), subscriber);
    }

    @Override
    public Reference<V> referenceFor(K key) {
        throw new UnsupportedOperationException("todo");
    }

    @Override
    public int hashCode() {
        return this.entrySet().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof Map) {
            Map map = (Map)obj;
            if (this.size() != map.size()) {
                return false;
            }
            try {
                for (int i = 0; i < this.kvStore.segments(); ++i) {
                    this.kvStore.entriesFor(i, e -> {
                        if (!BytesUtil.equals(e.value(), map.get(e.key()))) {
                            throw new InvalidSubscriberException();
                        }
                    });
                }
                return true;
            }
            catch (InvalidSubscriberException e2) {
                return false;
            }
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        try {
            for (int i = 0; i < this.kvStore.segments(); ++i) {
                this.kvStore.entriesFor(i, e -> sb.append(e.key()).append("=").append(e.value()).append(", "));
            }
            if (sb.length() > 3) {
                sb.setLength(sb.length() - 2);
            }
            return sb.append("}").toString();
        }
        catch (InvalidSubscriberException e2) {
            throw new AssertionError((Object)e2);
        }
    }
}

