/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.map;

import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.engine.api.map.MapEvent;
import net.openhft.chronicle.engine.api.map.MapEventListener;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireOut;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemovedEvent<K, V>
implements MapEvent<K, V> {
    private String assetName;
    @Nullable
    private K key;
    @Nullable
    private V oldValue;

    private RemovedEvent(String assetName, K key, V oldValue) {
        this.assetName = assetName;
        this.key = key;
        this.oldValue = oldValue;
    }

    @NotNull
    public static <K, V> RemovedEvent<K, V> of(String assetName, K key, V value) {
        return new RemovedEvent<K, V>(assetName, key, value);
    }

    @Override
    public String assetName() {
        return this.assetName;
    }

    @Override
    @NotNull
    public <K2, V2> MapEvent<K2, V2> translate(@NotNull Function<K, K2> keyFunction, @NotNull Function<V, V2> valueFunction) {
        return new RemovedEvent<K2, V2>(this.assetName, keyFunction.apply(this.key), valueFunction.apply(this.oldValue));
    }

    @Override
    @NotNull
    public <K2, V2> MapEvent<K2, V2> translate(@NotNull BiFunction<K, K2, K2> keyFunction, @NotNull BiFunction<V, V2, V2> valueFunction) {
        return new RemovedEvent<K2, V2>(this.assetName, keyFunction.apply(this.key, null), valueFunction.apply(this.oldValue, null));
    }

    @Override
    @Nullable
    public K key() {
        return this.key;
    }

    @Override
    @Nullable
    public V oldValue() {
        return this.oldValue;
    }

    @Override
    @Nullable
    public V value() {
        return null;
    }

    @Override
    public void apply(@NotNull MapEventListener<K, V> listener) {
        listener.remove(this.assetName, this.key, this.oldValue);
    }

    public int hashCode() {
        return Objects.hash("removed", this.key, this.oldValue);
    }

    public boolean equals(Object obj) {
        return Optional.ofNullable(obj).filter(o -> o instanceof RemovedEvent).map(o -> (RemovedEvent)o).filter(e -> Objects.equals(this.assetName, e.assetName)).filter(e -> BytesUtil.equals(this.key, e.key)).filter(e -> BytesUtil.equals(this.oldValue, e.oldValue)).isPresent();
    }

    @NotNull
    public String toString() {
        return "RemovedEvent{assetName='" + this.assetName + '\'' + ", key=" + this.key + ", oldValue=" + this.oldValue + '}';
    }

    public void readMarshallable(@NotNull WireIn wire) throws IllegalStateException {
        wire.read((WireKey)MapEvent.MapEventFields.assetName).text(s -> {
            this.assetName = s;
        });
        this.key = wire.read((WireKey)MapEvent.MapEventFields.key).object(Object.class);
        this.oldValue = wire.read((WireKey)MapEvent.MapEventFields.oldValue).object(Object.class);
    }

    public void writeMarshallable(@NotNull WireOut wire) {
        wire.write((WireKey)MapEvent.MapEventFields.assetName).text((CharSequence)this.assetName);
        wire.write((WireKey)MapEvent.MapEventFields.key).object(this.key);
        wire.write((WireKey)MapEvent.MapEventFields.oldValue).object(this.oldValue);
    }
}

