/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.map;

import java.util.function.Function;
import java.util.function.Supplier;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.NativeBytes;
import net.openhft.chronicle.engine.api.EngineReplication;
import net.openhft.chronicle.engine.api.map.KeyValueStore;
import net.openhft.chronicle.engine.api.map.MapEvent;
import net.openhft.chronicle.engine.api.pubsub.InvalidSubscriberException;
import net.openhft.chronicle.engine.api.pubsub.SubscriptionConsumer;
import net.openhft.chronicle.engine.api.tree.Asset;
import net.openhft.chronicle.engine.map.FilePerKeyValueStore;
import net.openhft.chronicle.engine.map.InsertedEvent;
import net.openhft.chronicle.wire.Marshallable;
import net.openhft.chronicle.wire.TextWire;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireOut;
import org.jetbrains.annotations.Nullable;

public class FilePerKeyBasedKeyMarshallableValueStore<K, V extends Marshallable>
implements KeyValueStore<K, V, V> {
    static ThreadLocal<Wire> threadLocalValueWire = ThreadLocal.withInitial(() -> new TextWire((Bytes)NativeBytes.nativeBytes()));
    private final FilePerKeyValueStore kvStore;
    private final Function<K, String> keyToString;
    private final Function<String, K> stringToKey;
    private final Supplier<V> createValue;

    static Wire valueWire() {
        Wire valueWire = threadLocalValueWire.get();
        valueWire.bytes().clear();
        return valueWire;
    }

    public FilePerKeyBasedKeyMarshallableValueStore(FilePerKeyValueStore kvStore, Function<K, String> keyToString, Function<String, K> stringToKey, Supplier<V> createValue) {
        this.kvStore = kvStore;
        this.keyToString = keyToString;
        this.stringToKey = stringToKey;
        this.createValue = createValue;
    }

    private V bytesToValue(BytesStore oldValue) {
        Marshallable ret;
        if (oldValue != null) {
            Marshallable using = (Marshallable)this.createValue.get();
            using.readMarshallable((WireIn)new TextWire(oldValue.bytesForRead()));
            ret = using;
        } else {
            ret = null;
        }
        return (V)ret;
    }

    @Override
    @Nullable
    public V getAndPut(K key, V value) {
        Wire valueWire = FilePerKeyBasedKeyMarshallableValueStore.valueWire();
        value.writeMarshallable((WireOut)valueWire);
        BytesStore oldValue = this.kvStore.getAndPut(this.keyToString.apply(key), (BytesStore)valueWire.bytes());
        return this.bytesToValue(oldValue);
    }

    @Override
    @Nullable
    public V getAndRemove(K key) {
        BytesStore oldValue = this.kvStore.getAndRemove(this.keyToString.apply(key));
        return this.bytesToValue(oldValue);
    }

    @Override
    @Nullable
    public V getUsing(K key, V value) {
        Wire valueWire = FilePerKeyBasedKeyMarshallableValueStore.valueWire();
        this.kvStore.getUsing(this.keyToString.apply(key), valueWire.bytes());
        if (value == null) {
            value = (Marshallable)this.createValue.get();
        }
        value.readMarshallable((WireIn)valueWire);
        return value;
    }

    @Override
    public long longSize() {
        return this.kvStore.longSize();
    }

    @Override
    public void keysFor(int segment, SubscriptionConsumer<K> kConsumer) throws InvalidSubscriberException {
        this.kvStore.keysFor(segment, (String key) -> kConsumer.accept(this.stringToKey.apply((String)key)));
    }

    @Override
    public void entriesFor(int segment, SubscriptionConsumer<MapEvent<K, V>> kvConsumer) throws InvalidSubscriberException {
        String assetName = this.asset().fullName();
        this.kvStore.entriesFor(segment, (MapEvent<String, BytesStore> event) -> kvConsumer.accept(InsertedEvent.of(assetName, this.stringToKey.apply((String)event.key()), this.bytesToValue((BytesStore)event.value()))));
    }

    @Override
    public void clear() {
        this.kvStore.clear();
    }

    @Override
    public boolean containsValue(V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Asset asset() {
        return this.kvStore.asset();
    }

    @Override
    @Nullable
    public KeyValueStore<K, V, V> underlying() {
        return null;
    }

    public void close() {
        this.kvStore.close();
    }

    @Override
    public void accept(EngineReplication.ReplicationEntry replicationEntry) {
        throw new UnsupportedOperationException();
    }
}

