/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.map;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import net.openhft.chronicle.bytes.IORuntimeException;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.engine.api.EngineReplication;
import net.openhft.chronicle.engine.api.map.KeyValueStore;
import net.openhft.chronicle.engine.api.map.MapEvent;
import net.openhft.chronicle.engine.api.pubsub.InvalidSubscriberException;
import net.openhft.chronicle.engine.api.pubsub.SubscriptionConsumer;
import net.openhft.chronicle.engine.api.tree.Asset;
import net.openhft.chronicle.engine.api.tree.AssetNotFoundException;
import net.openhft.chronicle.engine.api.tree.RequestContext;
import net.openhft.chronicle.engine.fs.Cluster;
import net.openhft.chronicle.engine.fs.Clusters;
import net.openhft.chronicle.engine.fs.HostDetails;
import net.openhft.chronicle.engine.map.AuthenticatedKeyValueStore;
import net.openhft.chronicle.engine.map.InsertedEvent;
import net.openhft.chronicle.engine.map.KVSSubscription;
import net.openhft.chronicle.engine.map.ObjectKVSSubscription;
import net.openhft.chronicle.engine.map.RemovedEvent;
import net.openhft.chronicle.engine.map.ReplicationHub;
import net.openhft.chronicle.engine.map.UpdatedEvent;
import net.openhft.chronicle.engine.tree.HostIdentifier;
import net.openhft.chronicle.hash.replication.EngineReplicationLangBytesConsumer;
import net.openhft.chronicle.hash.replication.SingleChronicleHashReplication;
import net.openhft.chronicle.map.ChronicleMap;
import net.openhft.chronicle.map.ChronicleMapBuilder;
import net.openhft.chronicle.map.MapEventListener;
import net.openhft.chronicle.network.connection.TcpChannelHub;
import net.openhft.chronicle.threads.api.EventLoop;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChronicleMapKeyValueStore<K, MV, V>
implements AuthenticatedKeyValueStore<K, MV, V>,
Closeable,
Supplier<EngineReplication> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChronicleMapKeyValueStore.class);
    private final ChronicleMap<K, V> chronicleMap;
    @NotNull
    private final ObjectKVSSubscription<K, MV, V> subscriptions;
    @Nullable
    private final EngineReplication engineReplicator;
    @NotNull
    private final Asset asset;
    @NotNull
    private final String assetFullName;
    @Nullable
    private final EventLoop eventLoop;
    private final AtomicBoolean isClosed;

    public ChronicleMapKeyValueStore(@NotNull RequestContext context, @NotNull Asset asset) {
        EngineReplication engineReplicator1;
        HostIdentifier hostIdentifier;
        ChronicleMapBuilder builder;
        PublishingOperations publishingOperations;
        long maxEntries;
        double averageValueSize;
        String basePath;
        block18: {
            this.isClosed = new AtomicBoolean();
            basePath = context.basePath();
            averageValueSize = context.getAverageValueSize();
            maxEntries = context.getEntries();
            this.asset = asset;
            this.assetFullName = asset.fullName();
            this.subscriptions = asset.acquireView(ObjectKVSSubscription.class, context);
            this.subscriptions.setKvStore(this);
            this.eventLoop = asset.findOrCreateView(EventLoop.class);
            this.eventLoop.start();
            publishingOperations = new PublishingOperations();
            builder = ChronicleMapBuilder.of((Class)context.keyType(), (Class)context.valueType());
            hostIdentifier = null;
            engineReplicator1 = null;
            try {
                engineReplicator1 = asset.acquireView(EngineReplication.class);
                EngineReplicationLangBytesConsumer langBytesConsumer = asset.findView(EngineReplicationLangBytesConsumer.class);
                hostIdentifier = asset.findOrCreateView(HostIdentifier.class);
                builder.replication(((SingleChronicleHashReplication.Builder)SingleChronicleHashReplication.builder().engineReplication(langBytesConsumer)).createWithId(hostIdentifier.hostId()));
            }
            catch (AssetNotFoundException anfe) {
                if (!LOGGER.isDebugEnabled()) break block18;
                LOGGER.debug("replication not enabled " + anfe.getMessage());
            }
        }
        this.engineReplicator = engineReplicator1;
        builder.eventListener((MapEventListener)publishingOperations);
        if (context.putReturnsNull() != Boolean.FALSE) {
            builder.putReturnsNull(true);
        }
        if (context.removeReturnsNull() != Boolean.FALSE) {
            builder.removeReturnsNull(true);
        }
        if (averageValueSize > 0.0) {
            builder.averageValueSize(averageValueSize);
        }
        if (maxEntries > 0L) {
            builder.entries(maxEntries);
        }
        if (basePath == null) {
            this.chronicleMap = builder.create();
        } else {
            String pathname = basePath + "/" + context.name();
            new File(basePath).mkdirs();
            try {
                this.chronicleMap = builder.createPersistedTo(new File(pathname));
            }
            catch (IOException e) {
                IORuntimeException iore = new IORuntimeException("Could not access " + pathname);
                iore.initCause((Throwable)e);
                throw iore;
            }
        }
        if (hostIdentifier != null) {
            Clusters clusters = asset.findView(Clusters.class);
            if (clusters == null) {
                LOGGER.warn("no clusters found.");
                return;
            }
            Cluster cluster = clusters.get(context.cluster());
            if (clusters == null) {
                LOGGER.warn("no cluster found.");
                return;
            }
            byte localIdentifier = hostIdentifier.hostId();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("hostDetails : localIdentifier=" + localIdentifier + ",cluster=" + cluster.hostDetails());
            }
            for (HostDetails hostDetails : cluster.hostDetails()) {
                int remoteIdentifier = hostDetails.hostId;
                if (remoteIdentifier <= localIdentifier) {
                    System.out.println("skipping : attempting to connect to localIdentifier=" + localIdentifier + ",remoteIdentifier=" + remoteIdentifier);
                    continue;
                }
                System.out.println("attempting to connect to localIdentifier=" + localIdentifier + ",remoteIdentifier=" + remoteIdentifier);
                TcpChannelHub tcpChannelHub = hostDetails.acquireTcpChannelHub(asset, this.eventLoop, context.wireType());
                ReplicationHub replicationHub = new ReplicationHub(context, tcpChannelHub, this.eventLoop, this.isClosed);
                try {
                    replicationHub.bootstrap(engineReplicator1, localIdentifier, (byte)remoteIdentifier);
                }
                catch (InterruptedException e) {
                    throw new AssertionError((Object)e);
                }
            }
            System.out.println("loop exit");
        }
    }

    @Override
    @NotNull
    public KVSSubscription<K, MV, V> subscription(boolean createIfAbsent) {
        return this.subscriptions;
    }

    @Override
    @Nullable
    public V getAndPut(K key, V value) {
        if (!this.isClosed.get()) {
            return (V)this.chronicleMap.put(key, value);
        }
        return null;
    }

    @Override
    @Nullable
    public V getAndRemove(K key) {
        if (!this.isClosed.get()) {
            return (V)this.chronicleMap.remove(key);
        }
        return null;
    }

    @Override
    public V getUsing(K key, @Nullable MV value) {
        if (value != null) {
            throw new UnsupportedOperationException("Mutable values not supported");
        }
        return (V)this.chronicleMap.getUsing(key, value);
    }

    @Override
    public long longSize() {
        return this.chronicleMap.size();
    }

    @Override
    public void keysFor(int segment, @NotNull SubscriptionConsumer<K> kConsumer) throws InvalidSubscriberException {
        SubscriptionConsumer.notifyEachEvent(this.chronicleMap.keySet(), kConsumer);
    }

    @Override
    public void entriesFor(int segment, @NotNull SubscriptionConsumer<MapEvent<K, V>> kvConsumer) throws InvalidSubscriberException {
        this.chronicleMap.entrySet().stream().map(e -> InsertedEvent.of(this.assetFullName, e.getKey(), e.getValue())).forEach(e -> {
            try {
                kvConsumer.accept((MapEvent)e);
            }
            catch (InvalidSubscriberException t) {
                throw Jvm.rethrow((Throwable)t);
            }
        });
    }

    @Override
    @NotNull
    public Iterator<Map.Entry<K, V>> entrySetIterator() {
        return this.chronicleMap.entrySet().iterator();
    }

    @Override
    @NotNull
    public Iterator<K> keySetIterator() {
        return this.chronicleMap.keySet().iterator();
    }

    @Override
    public void clear() {
        this.chronicleMap.clear();
    }

    @Override
    public boolean containsValue(V value) {
        throw new UnsupportedOperationException("todo");
    }

    @Override
    @NotNull
    public Asset asset() {
        return this.asset;
    }

    @Override
    @Nullable
    public KeyValueStore<K, MV, V> underlying() {
        return null;
    }

    @Override
    public void close() {
        this.isClosed.set(true);
        this.eventLoop.stop();
        net.openhft.chronicle.core.io.Closeable.closeQuietly((Object)this.asset.findView(TcpChannelHub.class));
        new Thread(() -> {
            Jvm.pause((long)1000L);
            this.chronicleMap.close();
        }, "close " + this.assetFullName).start();
    }

    @Override
    public void accept(@NotNull EngineReplication.ReplicationEntry replicationEntry) {
        if (!this.isClosed.get()) {
            this.engineReplicator.applyReplication(replicationEntry);
        } else {
            LOGGER.warn("message skipped as closed replicationEntry=" + replicationEntry);
        }
    }

    @Override
    @Nullable
    public EngineReplication get() {
        return this.engineReplicator;
    }

    class PublishingOperations
    extends MapEventListener<K, V> {
        PublishingOperations() {
        }

        public void onRemove(@NotNull K key, V value, boolean replicationEven) {
            if (ChronicleMapKeyValueStore.this.subscriptions.subscriberCount() > 0) {
                ChronicleMapKeyValueStore.this.subscriptions.notifyEvent(RemovedEvent.of(ChronicleMapKeyValueStore.this.assetFullName, key, value));
            }
        }

        public void onPut(@NotNull K key, V newValue, @Nullable V replacedValue, boolean replicationEvent) {
            if (ChronicleMapKeyValueStore.this.subscriptions.subscriberCount() > 0) {
                if (replacedValue == null) {
                    ChronicleMapKeyValueStore.this.subscriptions.notifyEvent(InsertedEvent.of(ChronicleMapKeyValueStore.this.assetFullName, key, newValue));
                } else {
                    ChronicleMapKeyValueStore.this.subscriptions.notifyEvent(UpdatedEvent.of(ChronicleMapKeyValueStore.this.assetFullName, key, replacedValue, newValue));
                }
            }
        }
    }
}

