/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.map;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.NativeBytesStore;
import net.openhft.chronicle.bytes.PointerBytesStore;
import net.openhft.chronicle.core.pool.ClassAliasPool;
import net.openhft.chronicle.engine.api.EngineReplication;
import net.openhft.chronicle.engine.api.tree.Asset;
import net.openhft.chronicle.engine.api.tree.RequestContext;
import net.openhft.chronicle.engine.api.tree.View;
import net.openhft.chronicle.engine.map.replication.Bootstrap;
import net.openhft.chronicle.hash.replication.EngineReplicationLangBytesConsumer;
import net.openhft.chronicle.map.EngineReplicationLangBytes;
import net.openhft.chronicle.wire.TextWire;
import net.openhft.chronicle.wire.Wires;
import net.openhft.chronicle.wire.WriteMarshallable;
import net.openhft.lang.io.ByteBufferBytes;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.IByteBufferBytes;
import net.openhft.lang.io.NativeBytes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CMap2EngineReplicator
implements EngineReplication,
EngineReplicationLangBytesConsumer,
View {
    private final RequestContext context;
    private final ThreadLocal<PointerBytesStore> keyLocal = ThreadLocal.withInitial(PointerBytesStore::new);
    private final ThreadLocal<PointerBytesStore> valueLocal = ThreadLocal.withInitial(PointerBytesStore::new);
    private EngineReplicationLangBytes engineReplicationLang;

    public CMap2EngineReplicator(RequestContext requestContext, @NotNull Asset asset) {
        this(requestContext);
        asset.addView(EngineReplicationLangBytesConsumer.class, this);
    }

    public CMap2EngineReplicator(RequestContext context) {
        this.context = context;
    }

    public void set(@NotNull EngineReplicationLangBytes engineReplicationLangBytes) {
        this.engineReplicationLang = engineReplicationLangBytes;
    }

    @NotNull
    Bytes toLangBytes(@NotNull BytesStore b) {
        if (b.underlyingObject() == null) {
            return NativeBytes.wrap((long)b.address(b.start()), (long)b.readRemaining());
        }
        ByteBuffer buffer = (ByteBuffer)b.underlyingObject();
        IByteBufferBytes wrap = ByteBufferBytes.wrap((ByteBuffer)buffer);
        wrap.limit((long)((int)b.readLimit()));
        return wrap;
    }

    public void put(@NotNull BytesStore key, @NotNull BytesStore value, byte remoteIdentifier, long timestamp) {
        this.engineReplicationLang.put(this.toLangBytes(key), this.toLangBytes(value), remoteIdentifier, timestamp);
    }

    private void remove(@NotNull BytesStore key, byte remoteIdentifier, long timestamp) {
        this.engineReplicationLang.remove(this.toLangBytes(key), remoteIdentifier, timestamp);
    }

    @Override
    public byte identifier() {
        return this.engineReplicationLang.identifier();
    }

    private void put(@NotNull EngineReplication.ReplicationEntry entry) {
        this.put(entry.key(), entry.value(), entry.identifier(), entry.timestamp());
    }

    private void remove(@NotNull EngineReplication.ReplicationEntry entry) {
        this.remove(entry.key(), entry.identifier(), entry.timestamp());
    }

    @Override
    public void applyReplication(@NotNull EngineReplication.ReplicationEntry entry) {
        if (entry.isDeleted()) {
            this.remove(entry);
        } else {
            this.put(entry);
        }
        this.setLastModificationTime(entry.identifier(), entry.bootStrapTimeStamp());
    }

    @Override
    @Nullable
    public EngineReplication.ModificationIterator acquireModificationIterator(final byte remoteIdentifier) {
        final EngineReplicationLangBytes.EngineModificationIterator instance = this.engineReplicationLang.acquireEngineModificationIterator(remoteIdentifier);
        return new EngineReplication.ModificationIterator(){

            @Override
            public void forEach(@NotNull Consumer<EngineReplication.ReplicationEntry> consumer) {
                while (this.hasNext()) {
                    this.nextEntry(entry -> {
                        consumer.accept(entry);
                        return true;
                    });
                }
            }

            @Override
            public boolean hasNext() {
                return instance.hasNext();
            }

            private boolean nextEntry(@NotNull EngineReplication.EntryCallback callback) {
                return instance.nextEntry((key, value, timestamp, identifier, isDeleted, bootStrapTimeStamp) -> callback.onEntry(new VanillaReplicatedEntry((BytesStore)this.toKey(key), (BytesStore)this.toValue(value), timestamp, identifier, isDeleted, bootStrapTimeStamp, remoteIdentifier)));
            }

            private net.openhft.chronicle.bytes.Bytes toKey(@NotNull Bytes key) {
                NativeBytesStore byteStore = NativeBytesStore.nativeStoreWithFixedCapacity((long)key.remaining());
                PointerBytesStore result = (PointerBytesStore)CMap2EngineReplicator.this.keyLocal.get();
                result.set(key.address(), key.capacity());
                result.copyTo((BytesStore)byteStore);
                return byteStore.bytesForRead();
            }

            @Nullable
            private net.openhft.chronicle.bytes.Bytes<Void> toValue(@Nullable Bytes value) {
                if (value == null) {
                    return null;
                }
                NativeBytesStore byteStore = NativeBytesStore.nativeStoreWithFixedCapacity((long)value.remaining());
                PointerBytesStore result = (PointerBytesStore)CMap2EngineReplicator.this.valueLocal.get();
                result.set(value.address(), value.capacity());
                result.copyTo((BytesStore)byteStore);
                return byteStore.bytesForRead();
            }

            @Override
            public void dirtyEntries(long fromTimeStamp) throws InterruptedException {
                instance.dirtyEntries(fromTimeStamp);
            }

            @Override
            public void setModificationNotifier(@NotNull EngineReplication.ModificationNotifier modificationNotifier) {
                instance.setModificationNotifier(() -> modificationNotifier.onChange());
            }
        };
    }

    @Override
    public long lastModificationTime(byte remoteIdentifier) {
        return this.engineReplicationLang.lastModificationTime(remoteIdentifier);
    }

    @Override
    public void setLastModificationTime(byte identifier, long timestamp) {
        this.engineReplicationLang.setLastModificationTime(identifier, timestamp);
    }

    @NotNull
    public String toString() {
        return "CMap2EngineReplicator{context=" + this.context + ", identifier=" + this.engineReplicationLang.identifier() + ", keyLocal=" + this.keyLocal + ", valueLocal=" + this.valueLocal + '}';
    }

    static {
        ClassAliasPool.CLASS_ALIASES.addAlias(new Class[]{VanillaReplicatedEntry.class});
        ClassAliasPool.CLASS_ALIASES.addAlias(new Class[]{Bootstrap.class});
    }

    public static class VanillaReplicatedEntry
    implements EngineReplication.ReplicationEntry {
        private BytesStore key;
        private BytesStore value;
        private long timestamp;
        private byte identifier;
        private byte remoteIdentifier;
        private boolean isDeleted;
        private long bootStrapTimeStamp;

        VanillaReplicatedEntry(@NotNull BytesStore key, @Nullable BytesStore value, long timestamp, byte identifier, boolean isDeleted, long bootStrapTimeStamp, byte remoteIdentifier) {
            this.key = key;
            this.remoteIdentifier = remoteIdentifier;
            assert (key.underlyingObject() == null);
            this.value = value;
            assert (value == null || value.underlyingObject() == null);
            this.timestamp = timestamp;
            this.identifier = identifier;
            this.isDeleted = isDeleted;
            this.bootStrapTimeStamp = bootStrapTimeStamp;
        }

        @Override
        public BytesStore key() {
            return this.key;
        }

        @Override
        public BytesStore value() {
            return this.value;
        }

        @Override
        public long timestamp() {
            return this.timestamp;
        }

        @Override
        public byte identifier() {
            return this.identifier;
        }

        @Override
        public byte remoteIdentifier() {
            return this.remoteIdentifier;
        }

        @Override
        public boolean isDeleted() {
            return this.isDeleted;
        }

        @Override
        public long bootStrapTimeStamp() {
            return this.bootStrapTimeStamp;
        }

        @Override
        public void key(BytesStore key) {
            this.key = key;
        }

        @Override
        public void value(BytesStore value) {
            this.value = value;
        }

        @Override
        public void timestamp(long timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public void identifier(byte identifier) {
            this.identifier = identifier;
        }

        @Override
        public void isDeleted(boolean isDeleted) {
            this.isDeleted = isDeleted;
        }

        @Override
        public void bootStrapTimeStamp(long bootStrapTimeStamp) {
            this.bootStrapTimeStamp = bootStrapTimeStamp;
        }

        public String toString() {
            net.openhft.chronicle.bytes.Bytes bytes = net.openhft.chronicle.bytes.Bytes.elasticByteBuffer();
            new TextWire(bytes).writeDocument(false, d -> d.write().typedMarshallable((WriteMarshallable)this));
            return "\n" + Wires.fromSizePrefixedBlobs((net.openhft.chronicle.bytes.Bytes)bytes, (long)bytes.readPosition(), (long)bytes.readLimit());
        }
    }
}

