/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.fs;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.engine.api.session.SessionProvider;
import net.openhft.chronicle.engine.api.tree.Asset;
import net.openhft.chronicle.engine.api.tree.View;
import net.openhft.chronicle.network.TCPRegistry;
import net.openhft.chronicle.network.connection.TcpChannelHub;
import net.openhft.chronicle.threads.api.EventLoop;
import net.openhft.chronicle.wire.Marshallable;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireOut;
import org.jetbrains.annotations.NotNull;

public class HostDetails
implements Marshallable,
View,
Closeable {
    public int hostId;
    public int tcpBufferSize;
    public String connectUri;
    public int timeoutMs;
    private final Map<InetSocketAddress, TcpChannelHub> tcpChannelHubs = new ConcurrentHashMap<InetSocketAddress, TcpChannelHub>();

    public void readMarshallable(@NotNull WireIn wire) throws IllegalStateException {
        wire.read(() -> "hostId").int32(i -> {
            this.hostId = i;
        }).read(() -> "tcpBufferSize").int32(i -> {
            this.tcpBufferSize = i;
        }).read(() -> "connectUri").text(i -> {
            this.connectUri = i;
        }).read(() -> "timeoutMs").int32(i -> {
            this.timeoutMs = i;
        });
    }

    public void writeMarshallable(@NotNull WireOut wire) {
        wire.write(() -> "hostId").int32(this.hostId).write(() -> "tcpBufferSize").int32(this.tcpBufferSize).write(() -> "connectUri").text((CharSequence)this.connectUri).write(() -> "timeoutMs").int32(this.timeoutMs);
    }

    public TcpChannelHub acquireTcpChannelHub(Asset asset, EventLoop eventLoop, Function<Bytes, Wire> wire) {
        InetSocketAddress addr = TCPRegistry.lookup((String)this.connectUri);
        SessionProvider sessionProvider = asset.findOrCreateView(SessionProvider.class);
        return this.tcpChannelHubs.computeIfAbsent(addr, hostPort -> new TcpChannelHub(sessionProvider, this.connectUri, eventLoop, wire, "hostId=" + this.hostId + ",connectUri=" + this.connectUri));
    }

    @Override
    public void close() throws IOException {
        this.tcpChannelHubs.values().forEach(TcpChannelHub::close);
    }

    public String toString() {
        return "HostDetails{hostId=" + this.hostId + ", connectUri='" + this.connectUri + '}';
    }
}

