/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.fs;

import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import net.openhft.chronicle.engine.api.tree.AssetTree;
import net.openhft.chronicle.engine.api.tree.View;
import net.openhft.chronicle.engine.fs.Cluster;
import net.openhft.chronicle.wire.Marshallable;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.Wires;
import net.openhft.chronicle.wire.WriteMarshallable;
import org.jetbrains.annotations.NotNull;

public class Clusters
implements Marshallable,
View {
    private final Map<String, Cluster> clusterMap = new ConcurrentSkipListMap<String, Cluster>();

    public void readMarshallable(@NotNull WireIn wire) throws IllegalStateException {
        StringBuilder clusterName = Wires.acquireStringBuilder();
        while (wire.hasMore()) {
            wire.readEventName(clusterName).marshallable(host -> {
                Cluster cluster = this.clusterMap.computeIfAbsent(clusterName.toString(), Cluster::new);
                cluster.readMarshallable(host);
            });
        }
    }

    public void writeMarshallable(@NotNull WireOut wire) {
        for (Map.Entry<String, Cluster> entry : this.clusterMap.entrySet()) {
            wire.writeEventName(entry::getKey).marshallable((WriteMarshallable)entry.getValue());
        }
    }

    public void install(@NotNull AssetTree assetTree) {
        assetTree.root().addView(Clusters.class, this);
    }

    public Cluster get(String cluster) {
        return this.clusterMap.get(cluster);
    }

    public void put(String clusterName, Cluster cluster) {
        this.clusterMap.put(clusterName, cluster);
    }
}

