/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.fs;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.engine.api.tree.View;
import net.openhft.chronicle.engine.fs.HostDetails;
import net.openhft.chronicle.wire.Marshallable;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.WriteMarshallable;
import org.jetbrains.annotations.NotNull;

public class Cluster
implements Marshallable,
View,
Closeable {
    private final Map<String, HostDetails> map;
    private final String clusterName;

    public Cluster(String clusterName) {
        this.clusterName = clusterName;
        this.map = new ConcurrentSkipListMap<String, HostDetails>();
    }

    public Cluster(String clusterName, Map<String, HostDetails> hostDetailsMap) {
        this.clusterName = clusterName;
        this.map = new ConcurrentSkipListMap<String, HostDetails>(hostDetailsMap);
    }

    public void readMarshallable(@NotNull WireIn wire) throws IllegalStateException {
        this.map.clear();
        StringBuilder hostDescription = new StringBuilder();
        while (wire.hasMore()) {
            wire.readEventName(hostDescription).marshallable(details -> {
                HostDetails hd = new HostDetails();
                hd.readMarshallable(details);
                this.map.put(hostDescription.toString(), hd);
            });
        }
    }

    public String clusterName() {
        return this.clusterName;
    }

    public void writeMarshallable(@NotNull WireOut wire) {
        for (Map.Entry<String, HostDetails> entry2 : this.map.entrySet()) {
            wire.writeEventName(entry2::getKey).marshallable((WriteMarshallable)entry2.getValue());
        }
    }

    public Collection<HostDetails> hostDetails() {
        return this.map.values();
    }

    public void close() {
        this.hostDetails().forEach(h -> this.close());
    }
}

