/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.api.tree;

import java.util.function.Function;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.core.pool.ClassAliasPool;
import net.openhft.chronicle.engine.api.collection.ValuesCollection;
import net.openhft.chronicle.engine.api.map.MapEvent;
import net.openhft.chronicle.engine.api.map.MapView;
import net.openhft.chronicle.engine.api.pubsub.Publisher;
import net.openhft.chronicle.engine.api.pubsub.Reference;
import net.openhft.chronicle.engine.api.pubsub.Replication;
import net.openhft.chronicle.engine.api.pubsub.Subscription;
import net.openhft.chronicle.engine.api.pubsub.TopicPublisher;
import net.openhft.chronicle.engine.api.session.Heartbeat;
import net.openhft.chronicle.engine.api.set.EntrySetView;
import net.openhft.chronicle.engine.api.set.KeySetView;
import net.openhft.chronicle.engine.map.ObjectKVSSubscription;
import net.openhft.chronicle.engine.map.RawKVSSubscription;
import net.openhft.chronicle.engine.tree.TopologicalEvent;
import net.openhft.chronicle.engine.tree.TopologySubscription;
import net.openhft.chronicle.wire.QueryWire;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.VanillaWireParser;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireParser;
import net.openhft.chronicle.wire.WireType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RequestContext
implements Cloneable {
    private String pathName;
    private String name;
    private Class viewType;
    private Class type;
    private Class type2;
    private String basePath;
    private Function<Bytes, Wire> wireType = WireType.TEXT;
    @Nullable
    private Boolean putReturnsNull = null;
    @Nullable
    private Boolean removeReturnsNull = null;
    @Nullable
    private Boolean bootstrap = null;
    private double averageValueSize;
    private long entries;
    private Boolean recurse;
    private boolean sealed = false;
    private String cluster = "cluster";

    private RequestContext() {
    }

    @NotNull
    public RequestContext cluster(String clusterTwo) {
        this.cluster = clusterTwo;
        return this;
    }

    @NotNull
    public String cluster() {
        return this.cluster;
    }

    public RequestContext(String pathName, String name) {
        this.pathName = pathName;
        this.name = name;
    }

    public RequestContext seal() {
        this.sealed = true;
        return this;
    }

    private static void addAlias(Class type, @NotNull String aliases) {
        ClassAliasPool.CLASS_ALIASES.addAlias(type, aliases);
    }

    @NotNull
    public static RequestContext requestContext() {
        return new RequestContext();
    }

    @NotNull
    public static RequestContext requestContext(@NotNull CharSequence uri) {
        return RequestContext.requestContext(uri.toString());
    }

    @NotNull
    public static RequestContext requestContext(@NotNull String uri) {
        int queryPos = uri.indexOf(63);
        String fullName = queryPos >= 0 ? uri.substring(0, queryPos) : uri;
        String query = queryPos >= 0 ? uri.substring(queryPos + 1) : "";
        int lastForwardSlash = fullName.lastIndexOf(47);
        if (lastForwardSlash > 0 && fullName.length() == lastForwardSlash + 1) {
            fullName = fullName.substring(0, fullName.length() - 1);
            lastForwardSlash = fullName.lastIndexOf(47);
        }
        String pathName = lastForwardSlash >= 0 ? fullName.substring(0, lastForwardSlash) : "";
        String name = lastForwardSlash >= 0 ? fullName.substring(lastForwardSlash + 1) : fullName;
        return new RequestContext(pathName, name).queryString(query);
    }

    @NotNull
    public Class<Subscription> getSubscriptionType() {
        Class elementType = this.elementType();
        return elementType == TopologicalEvent.class ? TopologySubscription.class : (elementType == BytesStore.class ? RawKVSSubscription.class : ObjectKVSSubscription.class);
    }

    @NotNull
    public RequestContext queryString(@NotNull String queryString) {
        if (queryString.isEmpty()) {
            return this;
        }
        WireParser parser = this.getWireParser();
        Bytes bytes = Bytes.from((String)queryString);
        QueryWire wire = new QueryWire(bytes);
        while (bytes.readRemaining() > 0L) {
            parser.parse((WireIn)wire);
        }
        return this;
    }

    @NotNull
    public WireParser getWireParser() {
        VanillaWireParser parser = new VanillaWireParser();
        parser.register(() -> "cluster", v -> v.text(x -> {
            this.cluster = x;
        }));
        parser.register(() -> "view", v -> v.text(this::view));
        parser.register(() -> "bootstrap", v -> v.bool(b -> {
            this.bootstrap = b;
        }));
        parser.register(() -> "putReturnsNull", v -> v.bool(b -> {
            this.putReturnsNull = b;
        }));
        parser.register(() -> "removeReturnsNull", v -> v.bool(b -> {
            this.removeReturnsNull = b;
        }));
        parser.register(() -> "basePath", v -> v.text(x -> {
            this.basePath = x;
        }));
        parser.register(() -> "viewType", v -> v.typeLiteral(x -> {
            this.viewType = x;
        }));
        parser.register(() -> "topicType", v -> v.typeLiteral(x -> {
            this.type = x;
        }));
        parser.register(() -> "keyType", v -> v.typeLiteral(x -> {
            this.type = x;
        }));
        parser.register(() -> "valueType", v -> v.typeLiteral(x -> {
            this.type2 = x;
        }));
        parser.register(() -> "messageType", v -> v.typeLiteral(x -> {
            this.type2 = x;
        }));
        parser.register(() -> "elementType", v -> v.typeLiteral(x -> {
            this.type = x;
        }));
        parser.register(WireParser.DEFAULT, ValueIn.DISCARD);
        return parser;
    }

    @NotNull
    RequestContext view(@NotNull String viewName) {
        try {
            Class clazz = RequestContext.lookupType(viewName);
            this.viewType(clazz);
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalArgumentException("Unknown view name:" + viewName);
        }
        return this;
    }

    static Class lookupType(@NotNull CharSequence typeName) throws IllegalArgumentException {
        return ClassAliasPool.CLASS_ALIASES.forName(typeName);
    }

    @NotNull
    public RequestContext type(Class type) {
        this.checkSealed();
        this.type = type;
        return this;
    }

    @NotNull
    public RequestContext keyType(Class type) {
        this.checkSealed();
        this.type = type;
        return this;
    }

    public Class type() {
        if (this.type == null) {
            return String.class;
        }
        return this.type;
    }

    public Class elementType() {
        return this.type2 == null ? this.type : this.type2;
    }

    public Class keyType() {
        if (this.type == null) {
            return String.class;
        }
        return this.type;
    }

    public Class valueType() {
        if (this.type2 == null) {
            return String.class;
        }
        return this.type2;
    }

    public Class topicType() {
        if (this.type == null) {
            return String.class;
        }
        return this.type;
    }

    public Class messageType() {
        if (this.type2 == null) {
            return String.class;
        }
        return this.type2;
    }

    @NotNull
    public RequestContext valueType(Class type2) {
        this.checkSealed();
        this.type2 = type2;
        return this;
    }

    @NotNull
    public RequestContext type2(Class type2) {
        this.checkSealed();
        this.type2 = type2;
        return this;
    }

    public Class type2() {
        if (this.type == null) {
            return String.class;
        }
        return this.type2;
    }

    @NotNull
    public String fullName() {
        return this.pathName.isEmpty() ? this.name : this.pathName + "/" + this.name;
    }

    @NotNull
    public RequestContext basePath(String basePath) {
        this.checkSealed();
        this.basePath = basePath;
        return this;
    }

    public String basePath() {
        return this.basePath;
    }

    @NotNull
    public RequestContext wireType(Function<Bytes, Wire> writeType) {
        this.checkSealed();
        this.wireType = writeType;
        return this;
    }

    public Function<Bytes, Wire> wireType() {
        return this.wireType;
    }

    public String namePath() {
        return this.pathName;
    }

    public String name() {
        return this.name;
    }

    public double getAverageValueSize() {
        return this.averageValueSize;
    }

    @NotNull
    public RequestContext averageValueSize(double averageValueSize) {
        this.checkSealed();
        this.averageValueSize = averageValueSize;
        return this;
    }

    public long getEntries() {
        return this.entries;
    }

    @NotNull
    public RequestContext entries(long entries) {
        this.checkSealed();
        this.entries = entries;
        return this;
    }

    @NotNull
    public RequestContext name(String name) {
        this.name = name;
        return this;
    }

    @NotNull
    public RequestContext viewType(Class assetType) {
        this.checkSealed();
        this.viewType = assetType;
        return this;
    }

    @Nullable
    public Class viewType() {
        return this.viewType;
    }

    @NotNull
    public RequestContext fullName(@NotNull String fullName) {
        int dirPos = fullName.lastIndexOf(47);
        this.pathName = dirPos >= 0 ? fullName.substring(0, dirPos) : "";
        this.name = dirPos >= 0 ? fullName.substring(dirPos + 1) : fullName;
        return this;
    }

    @Nullable
    public Boolean putReturnsNull() {
        return this.putReturnsNull;
    }

    @Nullable
    public Boolean removeReturnsNull() {
        return this.removeReturnsNull;
    }

    @Nullable
    public Boolean bootstrap() {
        return this.bootstrap;
    }

    @NotNull
    public RequestContext bootstrap(boolean bootstrap) {
        this.checkSealed();
        this.bootstrap = bootstrap;
        return this;
    }

    void checkSealed() {
        if (this.sealed) {
            throw new IllegalStateException();
        }
    }

    @NotNull
    public String toString() {
        return "RequestContext{pathName='" + this.pathName + '\'' + ", name='" + this.name + '\'' + ", viewType=" + this.viewType + ", type=" + this.type + ", type2=" + this.type2 + ", basePath='" + this.basePath + '\'' + ", wireType=" + this.wireType + ", putReturnsNull=" + this.putReturnsNull + ", removeReturnsNull=" + this.removeReturnsNull + ", bootstrap=" + this.bootstrap + ", averageValueSize=" + this.averageValueSize + ", entries=" + this.entries + ", recurse=" + this.recurse + '}';
    }

    public Boolean recurse() {
        return this.recurse;
    }

    @NotNull
    public RequestContext recurse(Boolean recurse) {
        this.recurse = recurse;
        return this;
    }

    @NotNull
    public RequestContext clone() {
        try {
            RequestContext clone = (RequestContext)super.clone();
            clone.sealed = false;
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    static {
        RequestContext.addAlias(MapView.class, "Map");
        RequestContext.addAlias(MapEvent.class, "MapEvent");
        RequestContext.addAlias(EntrySetView.class, "EntrySet");
        RequestContext.addAlias(KeySetView.class, "KeySet");
        RequestContext.addAlias(ValuesCollection.class, "Values");
        RequestContext.addAlias(Replication.class, "Replication");
        RequestContext.addAlias(Publisher.class, "Publisher, Pub");
        RequestContext.addAlias(TopicPublisher.class, "TopicPublisher, TopicPub");
        RequestContext.addAlias(ObjectKVSSubscription.class, "Subscription");
        RequestContext.addAlias(TopologySubscription.class, "topologySubscription");
        RequestContext.addAlias(Reference.class, "Reference, Ref");
        RequestContext.addAlias(Heartbeat.class, "Heartbeat");
    }
}

