/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.api.tree;

import java.util.Set;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.engine.api.management.ManagementTools;
import net.openhft.chronicle.engine.api.map.MapView;
import net.openhft.chronicle.engine.api.pubsub.Publisher;
import net.openhft.chronicle.engine.api.pubsub.Reference;
import net.openhft.chronicle.engine.api.pubsub.Subscriber;
import net.openhft.chronicle.engine.api.pubsub.Subscription;
import net.openhft.chronicle.engine.api.pubsub.TopicPublisher;
import net.openhft.chronicle.engine.api.pubsub.TopicSubscriber;
import net.openhft.chronicle.engine.api.tree.Asset;
import net.openhft.chronicle.engine.api.tree.AssetNotFoundException;
import net.openhft.chronicle.engine.api.tree.RequestContext;
import net.openhft.chronicle.engine.map.KVSSubscription;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface AssetTree
extends Closeable {
    public Asset root();

    @Nullable
    public Asset getAsset(String var1);

    @NotNull
    public Asset acquireAsset(@NotNull String var1) throws AssetNotFoundException;

    @NotNull
    default public <E> Set<E> acquireSet(@NotNull String uri, Class<E> eClass) throws AssetNotFoundException {
        return (Set)this.acquireView(RequestContext.requestContext(uri).view("set").type(eClass));
    }

    @NotNull
    default public <K, V> MapView<K, V, V> acquireMap(@NotNull String uri, Class<K> kClass, Class<V> vClass) throws AssetNotFoundException {
        return (MapView)this.acquireView(RequestContext.requestContext(uri).view("map").type(kClass).type2(vClass));
    }

    @NotNull
    default public <E> Publisher<E> acquirePublisher(@NotNull String uri, Class<E> eClass) throws AssetNotFoundException {
        return (Publisher)this.acquireView(RequestContext.requestContext(uri).view("pub").type(eClass));
    }

    @NotNull
    default public <E> Reference<E> acquireReference(@NotNull String uri, Class<E> eClass) throws AssetNotFoundException {
        return (Reference)this.acquireView(RequestContext.requestContext(uri).view("ref").type(eClass));
    }

    @NotNull
    default public <T, E> TopicPublisher<T, E> acquireTopicPublisher(@NotNull String uri, Class<T> topicClass, Class<E> messageClass) throws AssetNotFoundException {
        return (TopicPublisher)this.acquireView(RequestContext.requestContext(uri).view("topicPub").type(topicClass).type2(messageClass));
    }

    default public <E> void registerSubscriber(@NotNull String uri, Class<E> eClass, Subscriber<E> subscriber) throws AssetNotFoundException {
        RequestContext rc = RequestContext.requestContext(uri).type(eClass);
        this.acquireSubscription(rc).registerSubscriber(rc, subscriber);
    }

    default public <T, E> void registerTopicSubscriber(@NotNull String uri, Class<T> topicClass, Class<E> messageClass, TopicSubscriber<T, E> subscriber) throws AssetNotFoundException {
        RequestContext rc = RequestContext.requestContext(uri).keyType(topicClass).valueType(messageClass);
        ((KVSSubscription)this.acquireSubscription(rc)).registerTopicSubscriber(rc, subscriber);
    }

    @NotNull
    default public Subscription acquireSubscription(@NotNull RequestContext requestContext) throws AssetNotFoundException {
        Asset asset = this.acquireAsset(requestContext.fullName());
        Class<Subscription> subscriptionType = requestContext.getSubscriptionType();
        requestContext.viewType(subscriptionType);
        return asset.acquireView(subscriptionType, requestContext);
    }

    default public <E> void unregisterSubscriber(@NotNull String uri, Subscriber<E> subscriber) {
        RequestContext rc = RequestContext.requestContext(uri);
        Subscription subscription = this.getSubscription(rc);
        if (subscription == null) {
            subscriber.onEndOfSubscription();
        } else {
            subscription.unregisterSubscriber(subscriber);
        }
    }

    default public <T, E> void unregisterTopicSubscriber(@NotNull String uri, TopicSubscriber<T, E> subscriber) throws AssetNotFoundException {
        RequestContext rc = RequestContext.requestContext(uri).viewType(Subscriber.class);
        Subscription subscription = this.getSubscription(rc);
        if (subscription instanceof KVSSubscription) {
            ((KVSSubscription)subscription).unregisterTopicSubscriber(subscriber);
        } else {
            subscriber.onEndOfSubscription();
        }
    }

    @Nullable
    default public Subscription getSubscription(@NotNull RequestContext requestContext) {
        Asset asset = this.getAsset(requestContext.fullName());
        Class<Subscription> subscriptionType = requestContext.getSubscriptionType();
        requestContext.viewType(subscriptionType);
        return asset == null ? null : asset.getView(subscriptionType);
    }

    @NotNull
    default public <S> S acquireService(@NotNull String uri, Class<S> serviceType) throws AssetNotFoundException {
        return (S)this.acquireView(RequestContext.requestContext(uri).viewType(serviceType));
    }

    @NotNull
    default public <E> E acquireView(@NotNull RequestContext requestContext) throws AssetNotFoundException {
        return (E)this.acquireAsset(requestContext.fullName()).acquireView(requestContext);
    }

    default public AssetTree enableManagement() {
        ManagementTools.enableManagement(this);
        return this;
    }

    default public AssetTree enableManagement(int port) {
        ManagementTools.enableManagement(this, port);
        return this;
    }

    default public AssetTree disableManagement() {
        ManagementTools.disableManagement(this);
        return this;
    }
}

