/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.api.pubsub;

import java.util.Set;
import net.openhft.chronicle.engine.api.pubsub.ISubscriber;
import net.openhft.chronicle.engine.api.pubsub.InvalidSubscriberException;
import net.openhft.lang.Jvm;
import org.jetbrains.annotations.NotNull;

@FunctionalInterface
public interface SubscriptionConsumer<T> {
    public static <S extends ISubscriber> void notifyEachSubscriber(@NotNull Set<S> subs, @NotNull SubscriptionConsumer<S> doNotify) {
        doNotify.notifyEachSubscriber(subs);
    }

    default public void notifyEachSubscriber(@NotNull Set<T> subs) {
        subs.forEach(s -> {
            block4: {
                try {
                    this.accept(s);
                }
                catch (InvalidSubscriberException ise) {
                    subs.remove(s);
                    if (!(s instanceof ISubscriber)) break block4;
                    try {
                        ((ISubscriber)s).onEndOfSubscription();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    public static <E> void notifyEachEvent(@NotNull Set<E> subs, @NotNull SubscriptionConsumer<E> doNotify) throws InvalidSubscriberException {
        doNotify.notifyEachEvent(subs);
    }

    default public void notifyEachEvent(@NotNull Set<T> subs) throws InvalidSubscriberException {
        subs.forEach(s -> {
            try {
                this.accept(s);
            }
            catch (InvalidSubscriberException e) {
                throw Jvm.rethrow((Throwable)e);
            }
        });
    }

    public void accept(T var1) throws InvalidSubscriberException;
}

