/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine;

import java.util.Set;
import net.openhft.chronicle.engine.api.map.MapView;
import net.openhft.chronicle.engine.api.pubsub.Publisher;
import net.openhft.chronicle.engine.api.pubsub.Reference;
import net.openhft.chronicle.engine.api.pubsub.Subscriber;
import net.openhft.chronicle.engine.api.pubsub.TopicPublisher;
import net.openhft.chronicle.engine.api.pubsub.TopicSubscriber;
import net.openhft.chronicle.engine.api.tree.Asset;
import net.openhft.chronicle.engine.api.tree.AssetNotFoundException;
import net.openhft.chronicle.engine.api.tree.AssetTree;
import net.openhft.chronicle.engine.tree.VanillaAssetTree;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum Chassis {

    private static volatile AssetTree assetTree;

    public static void resetChassis() {
        assetTree = new VanillaAssetTree().forTesting();
    }

    public static AssetTree assetTree() {
        return assetTree;
    }

    @NotNull
    public static <E> Set<E> acquireSet(@NotNull String uri, Class<E> eClass) throws AssetNotFoundException {
        return assetTree.acquireSet(uri, eClass);
    }

    @NotNull
    public static <K, V> MapView<K, V, V> acquireMap(@NotNull String uri, Class<K> kClass, Class<V> vClass) throws AssetNotFoundException {
        return assetTree.acquireMap(uri, kClass, vClass);
    }

    @NotNull
    public static <E> Reference<E> acquireReference(@NotNull String uri, Class<E> eClass) throws AssetNotFoundException {
        return assetTree.acquireReference(uri, eClass);
    }

    @NotNull
    public static <E> Publisher<E> acquirePublisher(@NotNull String uri, Class<E> eClass) throws AssetNotFoundException {
        return assetTree.acquirePublisher(uri, eClass);
    }

    @NotNull
    public static <T, E> TopicPublisher<T, E> acquireTopicPublisher(@NotNull String uri, Class<T> tClass, Class<E> eClass) throws AssetNotFoundException {
        return assetTree.acquireTopicPublisher(uri, tClass, eClass);
    }

    public static <E> void registerSubscriber(@NotNull String uri, Class<E> eClass, Subscriber<E> subscriber) throws AssetNotFoundException {
        assetTree.registerSubscriber(uri, eClass, subscriber);
    }

    public static <E> void unregisterSubscriber(@NotNull String uri, Subscriber<E> subscriber) {
        assetTree.unregisterSubscriber(uri, subscriber);
    }

    public static <T, E> void registerTopicSubscriber(@NotNull String uri, Class<T> tClass, Class<E> eClass, TopicSubscriber<T, E> subscriber) throws AssetNotFoundException {
        assetTree.registerTopicSubscriber(uri, tClass, eClass, subscriber);
    }

    public static <T, E> void unregisterTopicSubscriber(@NotNull String uri, TopicSubscriber<T, E> subscriber) {
        assetTree.unregisterTopicSubscriber(uri, subscriber);
    }

    public static Asset acquireAsset(String name) throws AssetNotFoundException {
        return assetTree.acquireAsset(name);
    }

    @Nullable
    public static Asset getAsset(String uri) {
        return assetTree.getAsset(uri);
    }

    public static void close() {
        assetTree.close();
    }

    static {
        Chassis.resetChassis();
    }
}

