/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network.connection;

import java.io.Closeable;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Function;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.network.connection.CoreFields;
import net.openhft.chronicle.network.connection.TcpChannelHub;
import net.openhft.chronicle.wire.ParameterizeWireKey;
import net.openhft.chronicle.wire.ReadMarshallable;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.ValueOut;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.Wires;
import net.openhft.chronicle.wire.WriteMarshallable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractStatelessClient<E extends ParameterizeWireKey>
implements Closeable {
    @NotNull
    protected final TcpChannelHub hub;
    private final long cid;
    protected String csp;
    @NotNull
    StringBuilder eventName = new StringBuilder();

    public AbstractStatelessClient(@NotNull TcpChannelHub hub, long cid, @NotNull String csp) {
        this.cid = cid;
        this.csp = csp;
        this.hub = hub;
    }

    public static <E extends ParameterizeWireKey> Consumer<ValueOut> toParameters(@NotNull E eventId, Object ... args) {
        return out -> {
            WireKey[] paramNames = eventId.params();
            assert (args != null);
            assert (args.length == paramNames.length) : "methodName=" + eventId + ", args.length=" + args.length + ", paramNames.length=" + paramNames.length;
            if (paramNames.length == 1) {
                out.object(args[0]);
                return;
            }
            out.marshallable(m -> {
                for (int i = 0; i < paramNames.length; ++i) {
                    ValueOut vo = m.write(paramNames[i]);
                    vo.object(args[i]);
                }
            });
        };
    }

    @Nullable
    protected <R> R proxyReturnTypedObject(@NotNull E eventId, @Nullable R usingValue, @NotNull Class<R> resultType, Object ... args) {
        Function<ValueIn, Object> consumerIn = resultType == CharSequence.class && usingValue != null ? f -> {
            f.textTo((Appendable)((StringBuilder)usingValue));
            return usingValue;
        } : f -> f.object(resultType);
        return (R)this.proxyReturnWireConsumerInOut((WireKey)eventId, CoreFields.reply, AbstractStatelessClient.toParameters(eventId, args), (Function)consumerIn);
    }

    protected long proxyReturnLong(@NotNull WireKey eventId) {
        return this.proxyReturnWireConsumer(eventId, ValueIn::int64);
    }

    protected int proxyReturnInt(@NotNull WireKey eventId) {
        return this.proxyReturnWireConsumer(eventId, ValueIn::int32);
    }

    protected byte proxyReturnByte(@NotNull WireKey eventId) {
        return this.proxyReturnWireConsumer(eventId, ValueIn::int8);
    }

    protected byte proxyReturnByte(@NotNull WireKey reply, @NotNull WireKey eventId) {
        return this.proxyReturnWireConsumerInOut(eventId, reply, null, ValueIn::int8);
    }

    protected int proxyReturnUint16(@NotNull WireKey eventId) {
        return this.proxyReturnWireConsumer(eventId, ValueIn::uint16);
    }

    public <T> T proxyReturnWireConsumer(@NotNull WireKey eventId, @NotNull Function<ValueIn, T> consumer) {
        long startTime = System.currentTimeMillis();
        long tid = this.sendEvent(startTime, eventId, null);
        return this.readWire(tid, startTime, CoreFields.reply, consumer);
    }

    public <T> T proxyReturnWireConsumerInOut(@NotNull WireKey eventId, @NotNull WireKey reply, @Nullable Consumer<ValueOut> consumerOut, @NotNull Function<ValueIn, T> consumerIn) {
        long startTime = System.currentTimeMillis();
        long tid = this.sendEvent(startTime, eventId, consumerOut);
        return this.readWire(tid, startTime, reply, consumerIn);
    }

    protected void proxyReturnVoid(@NotNull WireKey eventId, @Nullable Consumer<ValueOut> consumer) {
        long startTime = System.currentTimeMillis();
        long tid = this.sendEvent(startTime, eventId, consumer);
        this.readWire(tid, startTime, CoreFields.reply, v -> v.marshallable(ReadMarshallable.DISCARD));
    }

    protected void proxyReturnVoid(@NotNull WireKey eventId) {
        this.proxyReturnVoid(eventId, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long sendEvent(long startTime, @NotNull WireKey eventId, @Nullable Consumer<ValueOut> consumer) {
        long tid;
        if (this.hub.outBytesLock().isHeldByCurrentThread()) {
            throw new IllegalStateException("Cannot view map while debugging");
        }
        this.hub.outBytesLock().lock();
        try {
            tid = this.writeMetaDataStartTime(startTime);
            this.hub.outWire().writeDocument(false, wireOut -> {
                ValueOut valueOut = wireOut.writeEventName(eventId);
                if (consumer == null) {
                    valueOut.marshallable(WriteMarshallable.EMPTY);
                } else {
                    consumer.accept(valueOut);
                }
            });
            this.hub.writeSocket((WireOut)this.hub.outWire());
        }
        finally {
            this.hub.outBytesLock().unlock();
        }
        return tid;
    }

    protected void sendEventAsync(@NotNull WireKey eventId, @Nullable Consumer<ValueOut> consumer) {
        if (this.hub.outBytesLock().isHeldByCurrentThread()) {
            throw new IllegalStateException("Cannot view map while debugging");
        }
        this.hub.outBytesLock().lock();
        try {
            this.sendEventAsyncWithoutLock(eventId, consumer);
        }
        finally {
            this.hub.outBytesLock().unlock();
        }
    }

    protected void sendEventAsyncWithoutLock(@NotNull WireKey eventId, @Nullable Consumer<ValueOut> consumer) {
        this.writeAsyncMetaData(System.currentTimeMillis());
        this.hub.outWire().writeDocument(false, wireOut -> {
            ValueOut valueOut = wireOut.writeEventName(eventId);
            if (consumer == null) {
                valueOut.marshallable(WriteMarshallable.EMPTY);
            } else {
                consumer.accept(valueOut);
            }
        });
        this.hub.writeSocket((WireOut)this.hub.outWire());
    }

    protected long writeMetaDataStartTime(long startTime) {
        return this.hub.writeMetaDataStartTime(startTime, this.hub.outWire(), this.csp, this.cid);
    }

    protected void writeMetaDataForKnownTID(long tid) {
        this.hub.writeMetaDataForKnownTID(tid, this.hub.outWire(), this.csp, this.cid);
    }

    protected void writeAsyncMetaData(long startTime) {
        this.hub.startTime(startTime);
        this.hub.writeAsyncHeader(this.hub.outWire(), this.csp, this.cid);
    }

    protected void checkIsData(@NotNull Wire wireIn) {
        int datalen = wireIn.bytes().readVolatileInt();
        if (!Wires.isData((long)datalen)) {
            throw new IllegalStateException("expecting a data blob, from ->" + Bytes.toString((Bytes)wireIn.bytes(), (long)0L, (long)wireIn.bytes().readLimit()));
        }
    }

    protected boolean readBoolean(long tid, long startTime) {
        assert (!this.hub.outBytesLock().isHeldByCurrentThread());
        long timeoutTime = startTime + this.hub.timeoutMs;
        Wire wireIn = this.hub.proxyReply(timeoutTime, tid);
        this.checkIsData(wireIn);
        return this.readReply((WireIn)wireIn, CoreFields.reply, ValueIn::bool);
    }

    protected <R> R readReply(@NotNull WireIn wireIn, @NotNull WireKey replyId, @NotNull Function<ValueIn, R> function) {
        ValueIn event = wireIn.read(this.eventName);
        if (replyId.contentEquals((CharSequence)this.eventName)) {
            return function.apply(event);
        }
        if (CoreFields.exception.contentEquals(this.eventName)) {
            throw Jvm.rethrow((Throwable)event.throwable(true));
        }
        throw new UnsupportedOperationException("unknown event=" + this.eventName);
    }

    protected void readReplyConsumer(@NotNull WireIn wireIn, @NotNull WireKey replyId, @NotNull Consumer<ValueIn> consumer) {
        ValueIn event = wireIn.read(this.eventName);
        if (replyId.contentEquals((CharSequence)this.eventName)) {
            consumer.accept(event);
            return;
        }
        if (CoreFields.exception.contentEquals(this.eventName)) {
            throw Jvm.rethrow((Throwable)event.throwable(true));
        }
        throw new UnsupportedOperationException("unknown event=" + this.eventName);
    }

    protected boolean proxyReturnBooleanWithArgs(@NotNull E eventId, Object ... args) {
        long startTime = System.currentTimeMillis();
        long tid = this.sendEvent(startTime, (WireKey)eventId, AbstractStatelessClient.toParameters(eventId, args));
        return this.readBoolean(tid, startTime);
    }

    protected boolean proxyReturnBooleanWithSequence(@NotNull E eventId, @NotNull Collection sequence) {
        long startTime = System.currentTimeMillis();
        long tid = this.sendEvent(startTime, (WireKey)eventId, out -> sequence.forEach(arg_0 -> ((ValueOut)out).object(arg_0)));
        return this.readBoolean(tid, startTime);
    }

    protected boolean proxyReturnBoolean(@NotNull WireKey eventId) {
        long startTime = System.currentTimeMillis();
        long tid = this.sendEvent(startTime, eventId, null);
        return this.readBoolean(tid, startTime);
    }

    private <T> T readWire(long tid, long startTime, @NotNull WireKey reply, @NotNull Function<ValueIn, T> c) {
        assert (!this.hub.outBytesLock().isHeldByCurrentThread());
        long timeoutTime = startTime + this.hub.timeoutMs;
        Wire wire = this.hub.proxyReply(timeoutTime, tid);
        this.checkIsData(wire);
        return this.readReply((WireIn)wire, reply, c);
    }

    protected int readInt(long tid, long startTime) {
        assert (!this.hub.outBytesLock().isHeldByCurrentThread());
        long timeoutTime = startTime + this.hub.timeoutMs;
        Wire wireIn = this.hub.proxyReply(timeoutTime, tid);
        this.checkIsData(wireIn);
        return wireIn.read((WireKey)CoreFields.reply).int32();
    }

    @Override
    public void close() {
        this.hub.close();
    }
}

