/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network.connection;

import net.openhft.chronicle.network.connection.AsyncSubscription;
import net.openhft.chronicle.network.connection.TcpChannelHub;
import net.openhft.chronicle.wire.WireOut;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractAsyncSubscription
implements AsyncSubscription {
    private final long tid;
    @NotNull
    private final TcpChannelHub hub;
    private String csp;

    public AbstractAsyncSubscription(@NotNull TcpChannelHub hub, String csp) {
        this.tid = hub.nextUniqueTransaction(System.currentTimeMillis());
        this.hub = hub;
        this.csp = csp;
    }

    @Override
    public long tid() {
        return this.tid;
    }

    @Override
    public void applySubscribe() {
        this.hub.outBytesLock().lock();
        try {
            this.hub.writeMetaDataForKnownTID(this.tid(), this.hub.outWire(), this.csp, 0L);
            this.hub.outWire().writeDocument(false, this::onSubscribe);
            this.hub.writeSocket((WireOut)this.hub.outWire());
        }
        finally {
            this.hub.outBytesLock().unlock();
        }
    }

    public abstract void onSubscribe(WireOut var1);

    @Override
    public void onClose() {
    }
}

