/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.tree;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import net.openhft.chronicle.core.util.ThrowingAcceptor;
import net.openhft.chronicle.engine.api.pubsub.InvalidSubscriberException;
import net.openhft.chronicle.engine.api.pubsub.Subscriber;
import net.openhft.chronicle.engine.api.tree.Asset;
import net.openhft.chronicle.engine.api.tree.RequestContext;
import net.openhft.chronicle.engine.tree.ExistingAssetEvent;
import net.openhft.chronicle.engine.tree.TopologicalEvent;
import net.openhft.chronicle.engine.tree.TopologySubscription;
import org.jetbrains.annotations.NotNull;

public class VanillaTopologySubscription
implements TopologySubscription {
    private final Asset asset;
    private final Set<Subscriber<TopologicalEvent>> subscribers = new CopyOnWriteArraySet<Subscriber<TopologicalEvent>>();

    public VanillaTopologySubscription(RequestContext requestContext, Asset asset) {
        this.asset = asset;
    }

    void bootstrapTree(@NotNull Asset asset, @NotNull Subscriber<TopologicalEvent> subscriber) throws InvalidSubscriberException {
        asset.forEachChild((ThrowingAcceptor<Asset, InvalidSubscriberException>)((ThrowingAcceptor)c -> {
            subscriber.onMessage(ExistingAssetEvent.of(asset.fullName(), c.name()));
            this.bootstrapTree((Asset)c, subscriber);
        }));
    }

    @Override
    public void registerSubscriber(@NotNull RequestContext rc, @NotNull Subscriber<TopologicalEvent> subscriber) {
        try {
            if (rc.bootstrap() != Boolean.FALSE) {
                Asset parent = this.asset.parent();
                String assetName = parent == null ? null : parent.fullName();
                subscriber.onMessage(ExistingAssetEvent.of(assetName, this.asset.name()));
                this.bootstrapTree(this.asset, subscriber);
            }
            this.subscribers.add(subscriber);
        }
        catch (InvalidSubscriberException invalidSubscriberException) {
            // empty catch block
        }
    }

    @Override
    public void unregisterSubscriber(Subscriber<TopologicalEvent> subscriber) {
        this.subscribers.remove(subscriber);
    }

    @Override
    public int keySubscriberCount() {
        return 0;
    }

    @Override
    public int entrySubscriberCount() {
        return this.subscriberCount();
    }

    @Override
    public int topicSubscriberCount() {
        return 0;
    }

    @Override
    public int subscriberCount() {
        return this.subscribers.size();
    }

    @Override
    public void notifyEvent(TopologicalEvent event) {
        TopologySubscription topologySubscription;
        for (Subscriber<TopologicalEvent> sub : this.subscribers) {
            try {
                sub.onMessage(event);
            }
            catch (InvalidSubscriberException expected) {
                this.subscribers.remove(sub);
            }
        }
        Asset parent = this.asset.parent();
        if (parent != null && (topologySubscription = parent.findView(TopologySubscription.class)) != null) {
            topologySubscription.notifyEvent(event);
        }
    }

    public void close() {
        for (Subscriber<TopologicalEvent> subscriber : this.subscribers) {
            try {
                subscriber.onEndOfSubscription();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

