/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.tree;

import java.util.function.BiPredicate;
import java.util.function.Supplier;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.util.ThrowingAcceptor;
import net.openhft.chronicle.engine.api.map.MapView;
import net.openhft.chronicle.engine.api.map.SubAsset;
import net.openhft.chronicle.engine.api.map.ValueReader;
import net.openhft.chronicle.engine.api.pubsub.InvalidSubscriberException;
import net.openhft.chronicle.engine.api.pubsub.Publisher;
import net.openhft.chronicle.engine.api.pubsub.Reference;
import net.openhft.chronicle.engine.api.pubsub.Subscription;
import net.openhft.chronicle.engine.api.pubsub.TopicSubscriber;
import net.openhft.chronicle.engine.api.tree.Asset;
import net.openhft.chronicle.engine.api.tree.AssetNotFoundException;
import net.openhft.chronicle.engine.api.tree.LeafViewFactory;
import net.openhft.chronicle.engine.api.tree.RequestContext;
import net.openhft.chronicle.engine.api.tree.WrappingViewFactory;
import net.openhft.chronicle.engine.map.ObjectKVSSubscription;
import net.openhft.chronicle.engine.pubsub.SimpleSubscription;
import net.openhft.chronicle.engine.pubsub.VanillaReference;
import net.openhft.chronicle.engine.tree.VanillaAsset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VanillaSubAsset<E>
implements SubAsset<E>,
Closeable,
TopicSubscriber<String, E> {
    @NotNull
    private final VanillaAsset parent;
    private final String name;
    @NotNull
    private final SimpleSubscription<E> subscription;
    @Nullable
    private Reference<E> reference;

    VanillaSubAsset(@NotNull RequestContext rc, @NotNull VanillaAsset parent, String name) throws AssetNotFoundException {
        ValueReader valueReader;
        this.parent = parent;
        this.name = name;
        this.reference = new VanillaReference(rc, this, parent.getView(MapView.class));
        try {
            valueReader = parent.acquireView(ValueReader.class, rc);
        }
        catch (Exception e) {
            valueReader = ValueReader.PASS;
        }
        this.subscription = new SimpleSubscription<E>(this.reference, valueReader == null ? ValueReader.PASS : valueReader);
    }

    @Override
    @NotNull
    public Subscription subscription(boolean createIfAbsent) {
        return this.subscription;
    }

    @Override
    @NotNull
    public <V> V getView(Class<V> vClass) {
        if (vClass == Reference.class || vClass == Publisher.class || vClass == Supplier.class) {
            return (V)this.reference;
        }
        if (vClass == Subscription.class || vClass == SimpleSubscription.class) {
            return (V)this.subscription;
        }
        throw new UnsupportedOperationException("todo");
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    @NotNull
    public <V> V acquireView(@NotNull Class<V> viewType, @NotNull RequestContext rc) throws AssetNotFoundException {
        if (viewType == Reference.class || viewType == Supplier.class) {
            return (V)this.reference;
        }
        if (viewType == Publisher.class) {
            if (this.reference == null) {
                return this.acquireViewFor(viewType, rc);
            }
            return (V)this.reference;
        }
        if (viewType == SimpleSubscription.class || viewType == ObjectKVSSubscription.class) {
            return (V)this.subscription;
        }
        throw new UnsupportedOperationException("todo vClass: " + viewType + ", rc: " + rc);
    }

    @NotNull
    private <V> V acquireViewFor(@NotNull Class<V> viewType, @NotNull RequestContext rc) throws AssetNotFoundException {
        return this.parent.getView(viewType);
    }

    @Override
    public <V> V addView(Class<V> viewType, V v) {
        return v;
    }

    @Override
    public boolean isSubAsset() {
        return true;
    }

    @Override
    public boolean hasChildren() {
        return false;
    }

    @Override
    public <I> void registerView(Class<I> iClass, I interceptor) {
        throw new UnsupportedOperationException("todo");
    }

    @Override
    public <W, U> void addWrappingRule(Class<W> iClass, String description, BiPredicate<RequestContext, Asset> predicate, WrappingViewFactory<W, U> factory, Class<U> underlyingType) {
        throw new UnsupportedOperationException("todo");
    }

    @Override
    public <W, U> void addWrappingRule(Class<W> iClass, String description, WrappingViewFactory<W, U> factory, Class<U> underlyingType) {
        throw new UnsupportedOperationException("todo");
    }

    @Override
    public <L> void addLeafRule(Class<L> iClass, String description, LeafViewFactory<L> factory) {
        throw new UnsupportedOperationException("todo");
    }

    @Override
    @NotNull
    public <I, U> I createWrappingView(Class viewType, RequestContext rc, Asset asset, U underling) throws AssetNotFoundException {
        throw new UnsupportedOperationException("todo");
    }

    @Override
    @NotNull
    public <I> I createLeafView(Class viewType, RequestContext rc, Asset asset) throws AssetNotFoundException {
        throw new UnsupportedOperationException("todo");
    }

    public void close() {
        this.subscription.close();
    }

    @Override
    public Asset parent() {
        return this.parent;
    }

    @Override
    @NotNull
    public Asset acquireAsset(RequestContext context, String fullName) throws AssetNotFoundException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <V> boolean hasFactoryFor(Class<V> viewType) {
        return false;
    }

    @Override
    @NotNull
    public Asset getChild(String name) {
        return null;
    }

    @Override
    public void removeChild(String name) {
    }

    @Override
    public void onMessage(@NotNull String name, E e) {
        if (name.equals(this.name)) {
            this.subscription.notifyMessage(e);
        }
    }

    @Override
    public boolean keyedView() {
        return false;
    }

    @Override
    public void forEachChild(ThrowingAcceptor<Asset, InvalidSubscriberException> child) throws InvalidSubscriberException {
    }
}

