/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.tree;

import java.util.Optional;
import net.openhft.chronicle.core.pool.ClassAliasPool;
import net.openhft.chronicle.engine.api.tree.Asset;
import net.openhft.chronicle.engine.api.tree.AssetNotFoundException;
import net.openhft.chronicle.engine.api.tree.AssetTree;
import net.openhft.chronicle.engine.api.tree.RequestContext;
import net.openhft.chronicle.engine.fs.ConfigurationFS;
import net.openhft.chronicle.engine.map.InsertedEvent;
import net.openhft.chronicle.engine.map.RemovedEvent;
import net.openhft.chronicle.engine.map.UpdatedEvent;
import net.openhft.chronicle.engine.tree.AddedAssetEvent;
import net.openhft.chronicle.engine.tree.ExistingAssetEvent;
import net.openhft.chronicle.engine.tree.HostIdentifier;
import net.openhft.chronicle.engine.tree.RemovedAssetEvent;
import net.openhft.chronicle.engine.tree.VanillaAsset;
import net.openhft.chronicle.threads.Threads;
import net.openhft.chronicle.threads.api.EventLoop;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VanillaAssetTree
implements AssetTree {
    final VanillaAsset root = new VanillaAsset(null, "");

    public VanillaAssetTree() {
    }

    public VanillaAssetTree(int hostId) {
        this.root.addView(HostIdentifier.class, new HostIdentifier((byte)hostId));
    }

    @NotNull
    public VanillaAssetTree forTesting() {
        return this.forTesting(true);
    }

    @NotNull
    public VanillaAssetTree forTesting(boolean daemon) {
        this.root.forTesting(daemon);
        return this;
    }

    @NotNull
    public VanillaAssetTree forRemoteAccess(String hostname, int port) {
        this.root.forRemoteAccess(hostname, port);
        return this;
    }

    @Override
    @NotNull
    public Asset acquireAsset(Class assetClass, @NotNull RequestContext context) throws AssetNotFoundException {
        String fullName = context.fullName();
        if (fullName.startsWith("/")) {
            fullName = fullName.substring(1);
        }
        return fullName.isEmpty() ? this.root : this.root.acquireAsset(context, fullName);
    }

    @Override
    @Nullable
    public Asset getAsset(@NotNull String fullName) {
        if (fullName.startsWith("/")) {
            fullName = fullName.substring(1);
        }
        return fullName.isEmpty() ? this.root : this.root.getAsset(fullName);
    }

    @Override
    @NotNull
    public Asset root() {
        return this.root;
    }

    public void close() {
        try {
            EventLoop view = this.root().findView(EventLoop.class);
            if (view != null) {
                view.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.root.close();
    }

    @NotNull
    public AssetTree withConfig(String etcDir, String baseDir) {
        Threads.withThreadGroup((ThreadGroup)this.root.getView(ThreadGroup.class), () -> {
            new ConfigurationFS("/etc", etcDir, baseDir).install(baseDir, this);
            return null;
        });
        return this;
    }

    @NotNull
    public String toString() {
        return "tree-" + Optional.ofNullable(this.root.getView(HostIdentifier.class)).map(HostIdentifier::hostId).orElseGet(() -> (byte)0);
    }

    static {
        ClassAliasPool.CLASS_ALIASES.addAlias(new Class[]{AddedAssetEvent.class, ExistingAssetEvent.class, RemovedAssetEvent.class, InsertedEvent.class, UpdatedEvent.class, RemovedEvent.class});
    }
}

