/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.tree;

import java.io.Closeable;
import java.io.IOException;
import java.util.Comparator;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.function.BiPredicate;
import net.openhft.chronicle.core.annotation.ForceInline;
import net.openhft.chronicle.core.util.ThrowingAcceptor;
import net.openhft.chronicle.engine.api.collection.ValuesCollection;
import net.openhft.chronicle.engine.api.map.KeyValueStore;
import net.openhft.chronicle.engine.api.map.MapView;
import net.openhft.chronicle.engine.api.map.SubscriptionKeyValueStore;
import net.openhft.chronicle.engine.api.pubsub.InvalidSubscriberException;
import net.openhft.chronicle.engine.api.pubsub.Publisher;
import net.openhft.chronicle.engine.api.pubsub.Reference;
import net.openhft.chronicle.engine.api.pubsub.Replication;
import net.openhft.chronicle.engine.api.pubsub.Subscription;
import net.openhft.chronicle.engine.api.pubsub.TopicPublisher;
import net.openhft.chronicle.engine.api.session.SessionProvider;
import net.openhft.chronicle.engine.api.set.EntrySetView;
import net.openhft.chronicle.engine.api.set.KeySetView;
import net.openhft.chronicle.engine.api.tree.Asset;
import net.openhft.chronicle.engine.api.tree.AssetNotFoundException;
import net.openhft.chronicle.engine.api.tree.LeafViewFactory;
import net.openhft.chronicle.engine.api.tree.RequestContext;
import net.openhft.chronicle.engine.api.tree.View;
import net.openhft.chronicle.engine.api.tree.WrappingViewFactory;
import net.openhft.chronicle.engine.collection.VanillaValuesCollection;
import net.openhft.chronicle.engine.map.AuthenticatedKeyValueStore;
import net.openhft.chronicle.engine.map.ObjectKVSSubscription;
import net.openhft.chronicle.engine.map.ObjectKeyValueStore;
import net.openhft.chronicle.engine.map.RawKVSSubscription;
import net.openhft.chronicle.engine.map.RemoteKVSSubscription;
import net.openhft.chronicle.engine.map.RemoteKeyValueStore;
import net.openhft.chronicle.engine.map.RemotePublisher;
import net.openhft.chronicle.engine.map.RemoteTopicPublisher;
import net.openhft.chronicle.engine.map.RemoteTopologySubscription;
import net.openhft.chronicle.engine.map.VanillaEntrySetView;
import net.openhft.chronicle.engine.map.VanillaKVSSubscription;
import net.openhft.chronicle.engine.map.VanillaKeyValueStore;
import net.openhft.chronicle.engine.map.VanillaMapView;
import net.openhft.chronicle.engine.map.VanillaStringMarshallableKeyValueStore;
import net.openhft.chronicle.engine.map.VanillaStringStringKeyValueStore;
import net.openhft.chronicle.engine.map.VanillaSubscriptionKeyValueStore;
import net.openhft.chronicle.engine.map.VanillaTopicPublisher;
import net.openhft.chronicle.engine.pubsub.VanillaReference;
import net.openhft.chronicle.engine.session.VanillaSessionProvider;
import net.openhft.chronicle.engine.set.VanillaKeySetView;
import net.openhft.chronicle.engine.tree.AddedAssetEvent;
import net.openhft.chronicle.engine.tree.HostIdentifier;
import net.openhft.chronicle.engine.tree.RemovedAssetEvent;
import net.openhft.chronicle.engine.tree.TopologySubscription;
import net.openhft.chronicle.engine.tree.VanillaReplication;
import net.openhft.chronicle.engine.tree.VanillaSubAsset;
import net.openhft.chronicle.engine.tree.VanillaTopologySubscription;
import net.openhft.chronicle.network.VanillaSessionDetails;
import net.openhft.chronicle.network.api.session.SessionDetails;
import net.openhft.chronicle.network.connection.TcpChannelHub;
import net.openhft.chronicle.threads.EventGroup;
import net.openhft.chronicle.threads.Threads;
import net.openhft.chronicle.threads.api.EventLoop;
import net.openhft.chronicle.wire.Marshallable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VanillaAsset
implements Asset,
net.openhft.chronicle.core.io.Closeable {
    public static final Comparator<Class> CLASS_COMPARATOR = Comparator.comparing(Class::getName);
    private static final String LAST = "{last}";
    private static final BiPredicate<RequestContext, Asset> ALWAYS = (rc, asset) -> true;
    final Map<Class, Object> viewMap = new ConcurrentSkipListMap<Class, Object>(CLASS_COMPARATOR);
    final ConcurrentMap<String, Asset> children = new ConcurrentSkipListMap<String, Asset>();
    private final Asset parent;
    @NotNull
    private final String name;
    private final Map<Class, SortedMap<String, WrappingViewRecord>> wrappingViewFactoryMap = new ConcurrentSkipListMap<Class, SortedMap<String, WrappingViewRecord>>(CLASS_COMPARATOR);
    private final Map<Class, LeafViewFactory> leafViewFactoryMap = new ConcurrentSkipListMap<Class, LeafViewFactory>(CLASS_COMPARATOR);
    private Boolean keyedAsset;

    public VanillaAsset(Asset asset, @NotNull String name) {
        TopologySubscription parentSubs;
        this.parent = asset;
        this.name = name;
        if ("".equals(name)) {
            assert (this.parent == null);
        } else {
            assert (this.parent != null);
            assert (name != null);
        }
        if (this.parent != null && (parentSubs = this.parent.findView(TopologySubscription.class)) != null) {
            parentSubs.notifyEvent(AddedAssetEvent.of(this.parent.fullName(), name));
        }
    }

    public void standardStack(boolean daemon) {
        this.addWrappingRule(Reference.class, "{last}reference", VanillaReference::new, MapView.class);
        this.addWrappingRule(Replication.class, "{last}replication", VanillaReplication::new, MapView.class);
        this.addWrappingRule(Publisher.class, "{last}publisher", VanillaReference::new, MapView.class);
        this.addWrappingRule(EntrySetView.class, "{last} entrySet", VanillaEntrySetView::new, MapView.class);
        this.addWrappingRule(KeySetView.class, "{last} keySet", VanillaKeySetView::new, MapView.class);
        this.addWrappingRule(ValuesCollection.class, "{last} values", VanillaValuesCollection::new, MapView.class);
        this.addWrappingRule(MapView.class, "{last} string key maps", VanillaMapView::new, ObjectKeyValueStore.class);
        String fullName = this.fullName();
        HostIdentifier hostIdentifier = this.findView(HostIdentifier.class);
        if (hostIdentifier != null) {
            fullName = "tree-" + hostIdentifier.hostId() + fullName;
        }
        ThreadGroup threadGroup = new ThreadGroup(fullName);
        this.addView(ThreadGroup.class, threadGroup);
        this.addLeafRule(EventLoop.class, "{last} event group", (rc, asset) -> (EventLoop)Threads.withThreadGroup((ThreadGroup)threadGroup, () -> {
            EventGroup eg = new EventGroup(daemon);
            eg.start();
            return eg;
        }));
        this.addView(SessionProvider.class, new VanillaSessionProvider());
    }

    public void forTesting() {
        this.forTesting(true);
    }

    public void forTesting(boolean daemon) {
        this.standardStack(daemon);
        this.addWrappingRule(TopicPublisher.class, "{last} topic publisher", VanillaTopicPublisher::new, MapView.class);
        this.addWrappingRule(Publisher.class, "{last}publisher", VanillaReference::new, MapView.class);
        this.addWrappingRule(ObjectKeyValueStore.class, "{last} authenticated", VanillaSubscriptionKeyValueStore::new, AuthenticatedKeyValueStore.class);
        this.addLeafRule(AuthenticatedKeyValueStore.class, "{last} vanilla", VanillaKeyValueStore::new);
        this.addLeafRule(SubscriptionKeyValueStore.class, "{last} vanilla", VanillaKeyValueStore::new);
        this.addLeafRule(KeyValueStore.class, "{last} vanilla", VanillaKeyValueStore::new);
        this.addLeafRule(ObjectKVSSubscription.class, "{last} vanilla", VanillaKVSSubscription::new);
        this.addLeafRule(TopologySubscription.class, "{last} vanilla", VanillaTopologySubscription::new);
    }

    public void forRemoteAccess(String hostname, int port) {
        this.standardStack(true);
        this.addLeafRule(ObjectKVSSubscription.class, "{last} Remote", RemoteKVSSubscription::new);
        this.addLeafRule(ObjectKeyValueStore.class, "{last} Remote AKVS", RemoteKeyValueStore::new);
        this.addWrappingRule(Publisher.class, "{last}publisher", RemotePublisher::new, MapView.class);
        this.addWrappingRule(TopicPublisher.class, "{last} topic publisher", RemoteTopicPublisher::new, MapView.class);
        this.addLeafRule(TopologySubscription.class, "{last} vanilla", RemoteTopologySubscription::new);
        SessionProvider sessionProvider = this.getView(SessionProvider.class);
        VanillaSessionDetails sessionDetails = new VanillaSessionDetails();
        sessionDetails.setUserId(System.getProperty("user.name"));
        sessionProvider.set((SessionDetails)sessionDetails);
        EventLoop eventLoop = this.findOrCreateView(EventLoop.class);
        if (this.getView(TcpChannelHub.class) == null) {
            this.addView(TcpChannelHub.class, Threads.withThreadGroup((ThreadGroup)this.findView(ThreadGroup.class), () -> new TcpChannelHub(sessionProvider, hostname, port, eventLoop)));
        }
    }

    public void enableTranslatingValuesToBytesStore() {
        this.addWrappingRule(ObjectKeyValueStore.class, "{Marshalling} string,string map", (rc, asset) -> rc.keyType() == String.class && rc.valueType() == String.class, VanillaStringStringKeyValueStore::new, AuthenticatedKeyValueStore.class);
        this.addWrappingRule(ObjectKeyValueStore.class, "{Marshalling} string,marshallable map", (rc, asset) -> rc.keyType() == String.class && Marshallable.class.isAssignableFrom(rc.valueType()), VanillaStringMarshallableKeyValueStore::new, AuthenticatedKeyValueStore.class);
        this.addLeafRule(RawKVSSubscription.class, "{last} vanilla", VanillaKVSSubscription::new);
    }

    @Override
    public <W, U> void addWrappingRule(Class<W> iClass, String description, BiPredicate<RequestContext, Asset> predicate, WrappingViewFactory<W, U> factory, Class<U> underlyingType) {
        SortedMap smap = this.wrappingViewFactoryMap.computeIfAbsent(iClass, k -> new ConcurrentSkipListMap());
        smap.put(description, new WrappingViewRecord<W, U>(predicate, factory, underlyingType));
    }

    @Override
    public <W, U> void addWrappingRule(Class<W> iClass, String description, WrappingViewFactory<W, U> factory, Class<U> underlyingType) {
        this.addWrappingRule(iClass, description, ALWAYS, factory, underlyingType);
        this.leafViewFactoryMap.remove(iClass);
    }

    @Override
    public <L> void addLeafRule(Class<L> iClass, String description, LeafViewFactory<L> factory) {
        this.leafViewFactoryMap.put(iClass, factory);
    }

    @Override
    @Nullable
    public <I, U> I createWrappingView(Class viewType, RequestContext rc, @NotNull Asset asset, @Nullable U underling) throws AssetNotFoundException {
        SortedMap<String, WrappingViewRecord> smap = this.wrappingViewFactoryMap.get(viewType);
        if (smap != null) {
            for (WrappingViewRecord wvRecord : smap.values()) {
                if (!wvRecord.predicate.test(rc, asset)) continue;
                if (underling == null) {
                    underling = asset.acquireView(wvRecord.underlyingType, rc);
                }
                return (I)wvRecord.factory.create(rc, asset, underling);
            }
        }
        if (this.parent == null) {
            return null;
        }
        return this.parent.createWrappingView(viewType, rc, asset, underling);
    }

    @Override
    @Nullable
    public <I> I createLeafView(Class viewType, RequestContext rc, Asset asset) throws AssetNotFoundException {
        LeafViewFactory lvFactory = this.leafViewFactoryMap.get(viewType);
        if (lvFactory != null) {
            return lvFactory.create(rc.clone().viewType(viewType), asset);
        }
        if (this.parent == null) {
            return null;
        }
        return this.parent.createLeafView(viewType, rc, asset);
    }

    @Override
    public boolean isSubAsset() {
        return false;
    }

    @Override
    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    @Override
    public void forEachChild(@NotNull ThrowingAcceptor<Asset, InvalidSubscriberException> consumer) throws InvalidSubscriberException {
        for (Asset child : this.children.values()) {
            consumer.accept((Object)child);
        }
    }

    @Override
    @ForceInline
    @Nullable
    public <V> V getView(@NotNull Class<V> vClass) {
        Object view = this.viewMap.get(vClass);
        return (V)view;
    }

    @Override
    @ForceInline
    @NotNull
    public String name() {
        return this.name;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public <V> V acquireView(@NotNull Class<V> viewType, RequestContext rc) throws AssetNotFoundException {
        Map<Class, Object> map = this.viewMap;
        synchronized (map) {
            V view = this.getView(viewType);
            if (view != null) {
                return view;
            }
            return (V)Threads.withThreadGroup((ThreadGroup)this.findView(ThreadGroup.class), () -> {
                Object leafView = this.createLeafView(viewType, rc, this);
                if (leafView != null) {
                    return this.addView(viewType, leafView);
                }
                Object wrappingView = this.createWrappingView(viewType, rc, this, null);
                if (wrappingView == null) {
                    throw new AssetNotFoundException("Unable to classify " + viewType.getName() + " context: " + rc);
                }
                return this.addView(viewType, wrappingView);
            });
        }
    }

    @Override
    public <V> V addView(Class<V> viewType, V view) {
        if (view instanceof View && ((View)view).keyedView()) {
            this.keyedAsset = true;
        }
        this.viewMap.put(viewType, view);
        return view;
    }

    @Override
    public <I> void registerView(Class<I> viewType, I view) {
        this.viewMap.put(viewType, view);
    }

    @Override
    @NotNull
    public Subscription subscription(boolean createIfAbsent) throws AssetNotFoundException {
        return createIfAbsent ? (Subscription)this.acquireView(ObjectKVSSubscription.class, RequestContext.requestContext()) : (Subscription)this.getView(ObjectKVSSubscription.class);
    }

    public void close() {
        this.viewMap.values().stream().filter(v -> v instanceof net.openhft.chronicle.core.io.Closeable).forEach(v -> {
            try {
                ((Closeable)v).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
        try {
            this.forEachChild((ThrowingAcceptor<Asset, InvalidSubscriberException>)((ThrowingAcceptor)net.openhft.chronicle.core.io.Closeable::close));
        }
        catch (InvalidSubscriberException e) {
            e.printStackTrace();
        }
    }

    @Override
    @ForceInline
    public Asset parent() {
        return this.parent;
    }

    @Override
    @NotNull
    public Asset acquireAsset(@NotNull RequestContext context, @NotNull String fullName) throws AssetNotFoundException {
        if (this.keyedAsset != Boolean.TRUE) {
            int pos = fullName.indexOf(47);
            if (pos == 0) {
                fullName = fullName.substring(1);
                pos = fullName.indexOf(47);
            }
            if (pos > 0) {
                String name1 = fullName.substring(0, pos);
                String name2 = fullName.substring(pos + 1);
                return this.getAssetOrANFE(context, name1).acquireAsset(context, name2);
            }
        }
        return this.getAssetOrANFE(context, fullName);
    }

    @Override
    public <V> boolean hasFactoryFor(Class<V> viewType) {
        return this.leafViewFactoryMap.containsKey(viewType) || this.wrappingViewFactoryMap.containsKey(viewType);
    }

    @Nullable
    private Asset getAssetOrANFE(@NotNull RequestContext context, @NotNull String name) throws AssetNotFoundException {
        Asset asset = (Asset)this.children.get(name);
        if (asset == null && (asset = this.createAsset(context, name)) == null) {
            throw new AssetNotFoundException(name);
        }
        return asset;
    }

    @Nullable
    protected Asset createAsset(@NotNull RequestContext context, @NotNull String name) {
        assert (name.length() > 0);
        return this.children.computeIfAbsent(name, this.keyedAsset != Boolean.TRUE ? n -> new VanillaAsset(this, name) : n -> new VanillaSubAsset(context, this, name));
    }

    @Override
    public Asset getChild(String name) {
        return (Asset)this.children.get(name);
    }

    @Override
    public void removeChild(String name) {
        Asset removed = (Asset)this.children.remove(name);
        if (removed == null) {
            return;
        }
        TopologySubscription topologySubscription = removed.findView(TopologySubscription.class);
        if (topologySubscription != null) {
            topologySubscription.notifyEvent(RemovedAssetEvent.of(this.fullName(), name));
        }
    }

    @NotNull
    public String toString() {
        return this.fullName();
    }

    static class WrappingViewRecord<W, U> {
        final BiPredicate<RequestContext, Asset> predicate;
        final WrappingViewFactory<W, U> factory;
        final Class<U> underlyingType;

        WrappingViewRecord(BiPredicate<RequestContext, Asset> predicate, WrappingViewFactory<W, U> factory, Class<U> underlyingType) {
            this.predicate = predicate;
            this.factory = factory;
            this.underlyingType = underlyingType;
        }

        @NotNull
        public String toString() {
            return "wraps " + this.underlyingType;
        }
    }
}

