/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.server.internal;

import java.util.Queue;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.openhft.chronicle.engine.api.map.MapEvent;
import net.openhft.chronicle.engine.api.pubsub.InvalidSubscriberException;
import net.openhft.chronicle.engine.api.pubsub.TopicSubscriber;
import net.openhft.chronicle.engine.api.tree.AssetTree;
import net.openhft.chronicle.engine.api.tree.RequestContext;
import net.openhft.chronicle.engine.map.ObjectKVSSubscription;
import net.openhft.chronicle.engine.server.internal.SubscriptionHandler;
import net.openhft.chronicle.network.connection.CoreFields;
import net.openhft.chronicle.wire.ParameterizeWireKey;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireOut;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectKVSubscriptionHandler
extends SubscriptionHandler<ObjectKVSSubscription> {
    private static final Logger LOG = LoggerFactory.getLogger(ObjectKVSubscriptionHandler.class);
    @Nullable
    private final BiConsumer<WireIn, Long> dataConsumer = (inWire, inputTid) -> {
        this.eventName.setLength(0);
        ValueIn valueIn = inWire.readEventName(this.eventName);
        if (EventId.registerTopicSubscriber.contentEquals(this.eventName)) {
            TopicSubscriber listener = new TopicSubscriber((Long)inputTid){
                final /* synthetic */ Long val$inputTid;
                {
                    this.val$inputTid = l;
                }

                public void onMessage(Object topic, Object message) throws InvalidSubscriberException {
                    ObjectKVSubscriptionHandler.this.publisher.add(publish -> {
                        publish.writeDocument(true, wire -> wire.writeEventName((WireKey)CoreFields.tid).int64(this.val$inputTid.longValue()));
                        publish.writeNotReadyDocument(false, wire -> wire.write((WireKey)CoreFields.reply).marshallable(m -> {
                            m.write(() -> "topic").object(topic);
                            m.write(() -> "message").object(message);
                        }));
                    });
                }

                @Override
                public void onEndOfSubscription() {
                    ObjectKVSubscriptionHandler.this.publisher.add(publish -> {
                        publish.writeDocument(true, wire -> wire.writeEventName((WireKey)CoreFields.tid).int64(this.val$inputTid.longValue()));
                        publish.writeNotReadyDocument(false, wire -> wire.writeEventName((WireKey)EventId.onEndOfSubscription).text((CharSequence)""));
                    });
                }
            };
            valueIn.marshallable(m -> {
                Class kClass = m.read(() -> "keyType").typeLiteral();
                Class vClass = m.read(() -> "valueType").typeLiteral();
                this.tidToListener.put(inputTid, listener);
                this.assetTree.registerTopicSubscriber(this.requestContext.name(), kClass, vClass, listener);
            });
            return;
        }
        if (EventId.unregisterTopicSubscriber.contentEquals(this.eventName)) {
            TopicSubscriber listener = (TopicSubscriber)this.tidToListener.remove(inputTid);
            if (listener == null) {
                LOG.warn("No subscriber to present to unsubscribe (" + inputTid + ")");
                return;
            }
            this.assetTree.unregisterTopicSubscriber(this.requestContext.name(), listener);
            this.publisher.add(publish -> {
                publish.writeDocument(true, wire -> wire.writeEventName((WireKey)CoreFields.tid).int64(inputTid.longValue()));
                publish.writeDocument(false, wire -> wire.write((WireKey)CoreFields.reply).typedMarshallable(null));
            });
            return;
        }
        if (this.before((Long)inputTid, valueIn)) {
            return;
        }
        this.outWire.writeDocument(true, wire -> this.outWire.writeEventName((WireKey)CoreFields.tid).int64(inputTid.longValue()));
        this.writeData(inWire.bytes(), out -> {
            if (this.after(this.eventName)) {
                return;
            }
            if (EventId.notifyEvent.contentEquals(this.eventName)) {
                ((ObjectKVSSubscription)this.subscription).notifyEvent((MapEvent)valueIn.typedMarshallable());
                this.outWire.writeEventName((WireKey)CoreFields.reply).int8((long)((ObjectKVSSubscription)this.subscription).entrySubscriberCount());
            }
        });
    };

    void process(@NotNull WireIn inWire, RequestContext requestContext, Queue<Consumer<Wire>> publisher, AssetTree assetTree, long tid, Wire outWire, ObjectKVSSubscription subscription) {
        this.setOutWire((WireOut)outWire);
        this.outWire = outWire;
        this.subscription = subscription;
        this.requestContext = requestContext;
        this.publisher = publisher;
        this.assetTree = assetTree;
        this.dataConsumer.accept(inWire, tid);
    }

    public static enum EventId implements ParameterizeWireKey
    {
        registerTopicSubscriber(new WireKey[0]),
        unregisterTopicSubscriber(new WireKey[0]),
        onEndOfSubscription(new WireKey[0]),
        notifyEvent(new WireKey[0]);

        private final WireKey[] params;

        private <P extends WireKey> EventId(P ... params) {
            this.params = params;
        }

        @NotNull
        public <P extends WireKey> P[] params() {
            return this.params;
        }
    }
}

