/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.server.internal;

import java.io.StreamCorruptedException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Queue;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.util.StringUtils;
import net.openhft.chronicle.engine.api.collection.ValuesCollection;
import net.openhft.chronicle.engine.api.map.KeyValueStore;
import net.openhft.chronicle.engine.api.map.MapView;
import net.openhft.chronicle.engine.api.pubsub.Publisher;
import net.openhft.chronicle.engine.api.pubsub.Replication;
import net.openhft.chronicle.engine.api.pubsub.TopicPublisher;
import net.openhft.chronicle.engine.api.session.Heartbeat;
import net.openhft.chronicle.engine.api.session.SessionProvider;
import net.openhft.chronicle.engine.api.set.EntrySetView;
import net.openhft.chronicle.engine.api.set.KeySetView;
import net.openhft.chronicle.engine.api.tree.Asset;
import net.openhft.chronicle.engine.api.tree.AssetTree;
import net.openhft.chronicle.engine.api.tree.RequestContext;
import net.openhft.chronicle.engine.api.tree.View;
import net.openhft.chronicle.engine.collection.CollectionWireHandler;
import net.openhft.chronicle.engine.map.ObjectKVSSubscription;
import net.openhft.chronicle.engine.server.internal.GenericWireAdapter;
import net.openhft.chronicle.engine.server.internal.MapWireHandler;
import net.openhft.chronicle.engine.server.internal.ObjectKVSubscriptionHandler;
import net.openhft.chronicle.engine.server.internal.PublisherHandler;
import net.openhft.chronicle.engine.server.internal.ReplicationHandler;
import net.openhft.chronicle.engine.server.internal.SystemHandler;
import net.openhft.chronicle.engine.server.internal.TopicPublisherHandler;
import net.openhft.chronicle.engine.server.internal.TopologySubscriptionHandler;
import net.openhft.chronicle.engine.server.internal.WireAdapter;
import net.openhft.chronicle.engine.tree.HostIdentifier;
import net.openhft.chronicle.engine.tree.TopologySubscription;
import net.openhft.chronicle.network.WireTcpHandler;
import net.openhft.chronicle.network.api.session.SessionDetails;
import net.openhft.chronicle.network.api.session.SessionDetailsProvider;
import net.openhft.chronicle.network.connection.CoreFields;
import net.openhft.chronicle.threads.api.EventLoop;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.Wires;
import net.openhft.chronicle.wire.YamlLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EngineWireHandler
extends WireTcpHandler {
    private static final Logger LOG = LoggerFactory.getLogger(EngineWireHandler.class);
    private final StringBuilder cspText = new StringBuilder();
    @NotNull
    private final CollectionWireHandler keySetHandler;
    @NotNull
    private final MapWireHandler mapWireHandler;
    @NotNull
    private final CollectionWireHandler entrySetHandler;
    @NotNull
    private final CollectionWireHandler valuesHandler;
    @NotNull
    private final ObjectKVSubscriptionHandler subscriptionHandler;
    @NotNull
    private final TopologySubscriptionHandler topologySubscriptionHandler;
    @NotNull
    private final TopicPublisherHandler topicPublisherHandler;
    @NotNull
    private final PublisherHandler publisherHandler;
    @NotNull
    private final ReplicationHandler replicationHandler;
    @NotNull
    private final AssetTree assetTree;
    @NotNull
    private final Consumer<WireIn> metaDataConsumer;
    private final StringBuilder lastCsp = new StringBuilder();
    private final StringBuilder eventName = new StringBuilder();
    private final SystemHandler systemHandler;
    private WireAdapter wireAdapter;
    private View view;
    private boolean isSystemMessage = true;
    private RequestContext requestContext;
    @Nullable
    private Class viewType;
    @Nullable
    private SessionProvider sessionProvider;
    @NotNull
    private Queue<Consumer<Wire>> publisher = new LinkedTransferQueue<Consumer<Wire>>();
    private long tid;
    @Nullable
    private HostIdentifier hostIdentifier;
    private Asset asset;
    @Nullable
    private EventLoop eventLoop;
    private AtomicBoolean isClosed;

    public EngineWireHandler(@NotNull Function<Bytes, Wire> byteToWire, @NotNull AssetTree assetTree, @NotNull AtomicBoolean isClosed) {
        super(byteToWire);
        this.sessionProvider = assetTree.root().getView(SessionProvider.class);
        this.eventLoop = assetTree.root().findOrCreateView(EventLoop.class);
        this.hostIdentifier = assetTree.root().findOrCreateView(HostIdentifier.class);
        this.assetTree = assetTree;
        this.mapWireHandler = new MapWireHandler();
        this.metaDataConsumer = this.wireInConsumer();
        this.keySetHandler = new CollectionWireHandler();
        this.entrySetHandler = new CollectionWireHandler();
        this.valuesHandler = new CollectionWireHandler();
        this.subscriptionHandler = new ObjectKVSubscriptionHandler();
        this.topologySubscriptionHandler = new TopologySubscriptionHandler();
        this.topicPublisherHandler = new TopicPublisherHandler();
        this.publisherHandler = new PublisherHandler();
        this.replicationHandler = new ReplicationHandler();
        this.systemHandler = new SystemHandler();
        this.isClosed = isClosed;
        this.eventLoop.start();
    }

    protected void publish(Wire out) {
        Consumer<Wire> wireConsumer = this.publisher.poll();
        if (wireConsumer != null) {
            wireConsumer.accept(out);
        }
    }

    @NotNull
    private Consumer<WireIn> wireInConsumer() {
        return wire -> {
            block8: {
                boolean bl = this.isSystemMessage = wire.bytes().readRemaining() == 0L;
                if (this.isSystemMessage) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("received system-meta-data");
                    }
                    return;
                }
                try {
                    this.readCsp((WireIn)wire);
                    this.readTid((WireIn)wire);
                    if (!this.hasCspChanged(this.cspText)) break block8;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("received meta-data:\n" + wire.bytes().toHexString());
                    }
                    this.requestContext = RequestContext.requestContext(this.cspText);
                    this.viewType = this.requestContext.viewType();
                    if (this.viewType == null) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("received system-meta-data");
                        }
                        this.isSystemMessage = true;
                        return;
                    }
                    this.asset = this.assetTree.acquireAsset(this.viewType, this.requestContext);
                    this.view = (View)this.asset.acquireView(this.requestContext);
                    this.requestContext.keyType();
                    if (this.viewType == MapView.class || this.viewType == EntrySetView.class || this.viewType == ValuesCollection.class || this.viewType == KeySetView.class || this.viewType == ObjectKVSSubscription.class || this.viewType == ObjectKVSSubscription.class || this.viewType == TopicPublisher.class || this.viewType == Publisher.class || this.viewType == TopologySubscription.class || this.viewType == Replication.class || this.viewType == Heartbeat.class) {
                        Class type = this.requestContext.type() == null ? String.class : this.requestContext.keyType();
                        Class type2 = this.requestContext.type2() == null ? String.class : this.requestContext.valueType();
                        this.wireAdapter = new GenericWireAdapter(type, type2);
                        break block8;
                    }
                    throw new UnsupportedOperationException("unsupported view type");
                }
                catch (Exception e) {
                    LOG.error("", (Throwable)e);
                    Jvm.rethrow((Throwable)e);
                }
            }
        };
    }

    private boolean hasCspChanged(@NotNull StringBuilder cspText) {
        boolean result;
        boolean bl = result = !cspText.equals(this.lastCsp);
        if (result) {
            this.lastCsp.setLength(0);
            this.lastCsp.append((CharSequence)cspText);
        }
        return result;
    }

    private void readTid(@NotNull WireIn metaDataWire) {
        ValueIn valueIn = metaDataWire.readEventName(this.eventName);
        if (CoreFields.tid.contentEquals(this.eventName)) {
            this.tid = valueIn.int64();
            this.eventName.setLength(0);
        } else {
            this.tid = -1L;
        }
    }

    protected void process(@NotNull WireIn in, @NotNull WireOut out, @NotNull SessionDetailsProvider sessionDetails) throws StreamCorruptedException {
        this.logYamlToStandardOut(in);
        in.readDocument(this.metaDataConsumer, wire -> {
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("received data:\n" + wire.bytes().toHexString());
                }
                this.sessionProvider.set((SessionDetails)sessionDetails);
                if (this.isSystemMessage) {
                    this.systemHandler.process(in, out, this.tid, sessionDetails);
                    return;
                }
                if (this.wireAdapter != null) {
                    if (this.viewType == MapView.class) {
                        this.mapWireHandler.process(in, out, (KeyValueStore)((MapView)this.view).underlying(), this.tid, this.wireAdapter, this.requestContext);
                        return;
                    }
                    if (this.viewType == EntrySetView.class) {
                        this.entrySetHandler.process(in, out, (EntrySetView)this.view, this.cspText, this.wireAdapter.entryToWire(), this.wireAdapter.wireToEntry(), HashSet::new, this.tid);
                        return;
                    }
                    if (this.viewType == KeySetView.class) {
                        this.keySetHandler.process(in, out, (KeySetView)this.view, this.cspText, this.wireAdapter.keyToWire(), this.wireAdapter.wireToKey(), HashSet::new, this.tid);
                        return;
                    }
                    if (this.viewType == ValuesCollection.class) {
                        this.valuesHandler.process(in, out, (ValuesCollection)((Object)this.view), this.cspText, this.wireAdapter.keyToWire(), this.wireAdapter.wireToKey(), ArrayList::new, this.tid);
                        return;
                    }
                    if (this.viewType == ObjectKVSSubscription.class) {
                        this.subscriptionHandler.process(in, this.requestContext, this.publisher, this.assetTree, this.tid, this.outWire, (ObjectKVSSubscription)this.view);
                        return;
                    }
                    if (this.viewType == TopologySubscription.class) {
                        this.topologySubscriptionHandler.process(in, this.requestContext, this.publisher, this.assetTree, this.tid, this.outWire, (TopologySubscription)this.view);
                        return;
                    }
                    if (this.viewType == TopicPublisher.class) {
                        this.topicPublisherHandler.process(in, this.publisher, this.tid, this.outWire, (TopicPublisher)this.view, this.wireAdapter);
                        return;
                    }
                    if (this.viewType == Publisher.class) {
                        this.publisherHandler.process(in, this.publisher, this.tid, (Publisher)((Object)this.view), this.outWire, this.wireAdapter);
                        return;
                    }
                    if (this.viewType == Replication.class) {
                        this.replicationHandler.process(in, this.publisher, this.tid, this.outWire, this.hostIdentifier, (Replication)this.view, this.isClosed, this.eventLoop);
                        return;
                    }
                }
                if (StringUtils.endsWith((CharSequence)this.cspText, (String)"?view=queue")) {
                    // empty if block
                }
            }
            catch (Exception e) {
                LOG.error("", (Throwable)e);
            }
            finally {
                this.sessionProvider.remove();
            }
        });
    }

    private void logYamlToStandardOut(@NotNull WireIn in) {
        if (YamlLogging.showServerReads) {
            try {
                LOG.info("\nServer Reads:\n" + Wires.fromSizePrefixedBlobs((Bytes)in.bytes()));
            }
            catch (Exception e) {
                LOG.info("\n\n" + Bytes.toString((Bytes)in.bytes()));
            }
        }
    }

    private void readCsp(@NotNull WireIn wireIn) {
        StringBuilder keyName = Wires.acquireStringBuilder();
        this.cspText.setLength(0);
        ValueIn read = wireIn.readEventName(keyName);
        if (CoreFields.csp.contentEquals(keyName)) {
            read.textTo((Appendable)this.cspText);
        } else if (CoreFields.cid.contentEquals(keyName)) {
            long cid = read.int64();
            CharSequence s = this.mapWireHandler.getCspForCid(cid);
            this.cspText.append(s);
        }
    }
}

