/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.pubsub;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.engine.api.map.ValueReader;
import net.openhft.chronicle.engine.api.pubsub.InvalidSubscriberException;
import net.openhft.chronicle.engine.api.pubsub.Reference;
import net.openhft.chronicle.engine.api.pubsub.Subscriber;
import net.openhft.chronicle.engine.api.pubsub.Subscription;
import net.openhft.chronicle.engine.api.pubsub.SubscriptionConsumer;
import net.openhft.chronicle.engine.api.tree.RequestContext;
import org.jetbrains.annotations.NotNull;

public class SimpleSubscription<E>
implements Subscription<E> {
    private final Set<Subscriber<E>> subscribers = new CopyOnWriteArraySet<Subscriber<E>>();
    private final Reference<E> currentValue;
    private final ValueReader<Object, E> valueReader;

    public SimpleSubscription(Reference<E> reference, ValueReader<Object, E> valueReader) {
        this.currentValue = reference;
        this.valueReader = valueReader;
    }

    @Override
    public void registerSubscriber(@NotNull RequestContext rc, @NotNull Subscriber<E> subscriber) {
        this.subscribers.add(subscriber);
        if (rc.bootstrap() != Boolean.FALSE) {
            try {
                subscriber.onMessage(this.currentValue.get());
            }
            catch (InvalidSubscriberException e) {
                this.subscribers.remove(subscriber);
            }
        }
    }

    @Override
    public void unregisterSubscriber(Subscriber<E> subscriber) {
        this.subscribers.remove(subscriber);
    }

    @Override
    public int keySubscriberCount() {
        return this.subscriberCount();
    }

    @Override
    public int entrySubscriberCount() {
        return 0;
    }

    @Override
    public int topicSubscriberCount() {
        return 0;
    }

    @Override
    public int subscriberCount() {
        return this.subscribers.size();
    }

    public void notifyMessage(Object e) {
        try {
            Object ee = e instanceof BytesStore ? this.valueReader.readFrom(e, null) : e;
            SubscriptionConsumer.notifyEachSubscriber(this.subscribers, s -> s.onMessage(ee));
        }
        catch (ClassCastException e1) {
            System.err.println("Is " + this.valueReader + " the correct ValueReader?");
            throw e1;
        }
    }

    @Override
    public boolean keyedView() {
        return false;
    }

    public void close() {
        for (Subscriber<E> subscriber : this.subscribers) {
            try {
                subscriber.onEndOfSubscription();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

