/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.map;

import net.openhft.chronicle.engine.api.map.MapView;
import net.openhft.chronicle.engine.api.pubsub.TopicPublisher;
import net.openhft.chronicle.engine.api.pubsub.TopicSubscriber;
import net.openhft.chronicle.engine.api.tree.Asset;
import net.openhft.chronicle.engine.api.tree.AssetNotFoundException;
import net.openhft.chronicle.engine.api.tree.RequestContext;
import net.openhft.chronicle.engine.map.KVSSubscription;
import org.jetbrains.annotations.NotNull;

public class VanillaTopicPublisher<T, M>
implements TopicPublisher<T, M> {
    private final Class<T> tClass;
    private final Class<M> mClass;
    private Asset asset;
    private MapView<T, M, M> underlying;

    public VanillaTopicPublisher(@NotNull RequestContext context, Asset asset, @NotNull MapView<T, M, M> underlying) throws AssetNotFoundException {
        this(asset, context.type(), context.type2(), underlying);
    }

    VanillaTopicPublisher(Asset asset, Class<T> tClass, Class<M> mClass, MapView<T, M, M> underlying) {
        this.asset = asset;
        this.tClass = tClass;
        this.mClass = mClass;
        this.underlying = underlying;
    }

    @Override
    public void publish(T topic, M message) {
        this.underlying.set(topic, message);
    }

    @Override
    public Asset asset() {
        return this.asset;
    }

    @Override
    public MapView<T, M, M> underlying() {
        return this.underlying;
    }

    @Override
    public void registerTopicSubscriber(TopicSubscriber<T, M> topicSubscriber) throws AssetNotFoundException {
        KVSSubscription subscription = (KVSSubscription)this.asset.subscription(true);
        subscription.registerTopicSubscriber(RequestContext.requestContext().bootstrap(true).type(this.tClass).type2(this.mClass), topicSubscriber);
    }
}

