/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.map;

import net.openhft.chronicle.engine.api.pubsub.InvalidSubscriberException;
import net.openhft.chronicle.engine.api.pubsub.Publisher;
import net.openhft.chronicle.engine.api.pubsub.Subscriber;
import net.openhft.chronicle.engine.api.tree.Asset;
import net.openhft.chronicle.engine.api.tree.AssetNotFoundException;
import net.openhft.chronicle.engine.api.tree.RequestContext;
import net.openhft.chronicle.engine.server.internal.PublisherHandler;
import net.openhft.chronicle.network.connection.AbstractAsyncSubscription;
import net.openhft.chronicle.network.connection.AbstractStatelessClient;
import net.openhft.chronicle.network.connection.CoreFields;
import net.openhft.chronicle.network.connection.TcpChannelHub;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.Wires;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemotePublisher<E>
extends AbstractStatelessClient<PublisherHandler.EventId>
implements Publisher<E> {
    private final Class<E> messageClass;

    public RemotePublisher(@NotNull RequestContext context, @NotNull Asset asset, Object underlying) throws AssetNotFoundException {
        super(asset.findView(TcpChannelHub.class), 0L, RemotePublisher.toUri(context));
        this.messageClass = context.messageType();
    }

    private static String toUri(@NotNull RequestContext context) {
        StringBuilder uri = new StringBuilder("/" + context.fullName() + "?view=" + "publisher");
        if (context.valueType() != String.class) {
            uri.append("&messageType=").append(context.messageType().getName());
        }
        return uri.toString();
    }

    @Override
    public void publish(E event) {
        this.checkEvent(event);
        this.sendEventAsync((WireKey)PublisherHandler.EventId.publish, valueOut -> valueOut.object(event));
    }

    @Override
    public void registerSubscriber(final @NotNull Subscriber subscriber) throws AssetNotFoundException {
        if (this.hub.outBytesLock().isHeldByCurrentThread()) {
            throw new IllegalStateException("Cannot view map while debugging");
        }
        AbstractAsyncSubscription asyncSubscription = new AbstractAsyncSubscription(this.hub, this.csp){

            @Override
            public void onSubscribe(@NotNull WireOut wireOut) {
                wireOut.writeEventName((WireKey)PublisherHandler.EventId.registerTopicSubscriber).text((CharSequence)"");
            }

            @Override
            public void onConsumer(@NotNull WireIn w) {
                w.readDocument(null, d -> {
                    StringBuilder eventname = Wires.acquireStringBuilder();
                    ValueIn valueIn = d.readEventName(eventname);
                    if (PublisherHandler.EventId.onEndOfSubscription.contentEquals(eventname)) {
                        subscriber.onEndOfSubscription();
                        RemotePublisher.this.hub.unsubscribe(this.tid());
                    } else if (CoreFields.reply.contentEquals(eventname)) {
                        valueIn.marshallable(m -> {
                            Object message = m.read(() -> "message").object(RemotePublisher.this.messageClass);
                            RemotePublisher.this.onEvent(message, subscriber);
                        });
                    }
                });
            }
        };
        this.hub.subscribe(asyncSubscription);
    }

    private void onEvent(@Nullable E message, @NotNull Subscriber<E> subscriber) {
        try {
            if (message != null) {
                subscriber.onMessage(message);
            }
        }
        catch (InvalidSubscriberException invalidSubscriberException) {
            // empty catch block
        }
    }

    private void checkEvent(@Nullable Object key) {
        if (key == null) {
            throw new NullPointerException("event can not be null");
        }
    }
}

