/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.map;

import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.function.Consumer;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.core.values.IntValue;
import net.openhft.chronicle.engine.api.EngineReplication;
import net.openhft.chronicle.engine.api.map.KeyValueStore;
import net.openhft.lang.collection.ATSDirectBitSet;
import net.openhft.lang.collection.DirectBitSet;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.DirectStore;
import net.openhft.lang.model.Copyable;
import net.openhft.lang.model.DataValueClasses;
import net.openhft.lang.model.constraints.MaxSize;
import org.jetbrains.annotations.NotNull;

public class ChronicleMapBackedEngineReplication<Store>
implements EngineReplication,
Closeable {
    public static final int RESERVED_MOD_ITER = 8;
    public static final int MAX_MODIFICATION_ITERATORS = 135;
    public static final int DIRTY_WORD_COUNT = 3;
    private static ThreadLocal<Instances> threadLocalInstances = ThreadLocal.withInitial(Instances::new);
    private KeyValueStore<BytesStore, ReplicationData, ReplicationData> keyReplicationData;
    private KeyValueStore<IntValue, RemoteNodeReplicationState, RemoteNodeReplicationState> modIterState;
    private final byte identifier;
    private final Store store;
    private final ChangeApplier<Store> changeApplier;
    private final GetValue<Store> getValue;
    private final AtomicReferenceArray<ChronicleMapBackedModificationIterator> modificationIterators = new AtomicReferenceArray(135);
    private final DirectBitSet modificationIteratorsRequiringSettingBootstrapTimestamp = ChronicleMapBackedEngineReplication.createModIterBitSet();
    private final DirectBitSet modIterSet = ChronicleMapBackedEngineReplication.createModIterBitSet();

    private static int idToInt(byte identifier) {
        return identifier & 0xFF;
    }

    private static ATSDirectBitSet createModIterBitSet() {
        return new ATSDirectBitSet((Bytes)new DirectStore(null, 24L, true).bytes());
    }

    private static void initZeroStateForAllPossibleRemoteIdentifiers(KeyValueStore<IntValue, RemoteNodeReplicationState, RemoteNodeReplicationState> modIterState) {
        Instances i = threadLocalInstances.get();
        for (int id = 0; id < 256; ++id) {
            i.identifier.setValue(id);
            modIterState.put(i.identifier, i.zeroState);
        }
    }

    public ChronicleMapBackedEngineReplication(KeyValueStore<BytesStore, ReplicationData, ReplicationData> keyReplicationData, KeyValueStore<IntValue, RemoteNodeReplicationState, RemoteNodeReplicationState> modIterState, byte identifier, Store store, ChangeApplier<Store> changeApplier, GetValue<Store> getValue) {
        this.keyReplicationData = keyReplicationData;
        this.modIterState = modIterState;
        ChronicleMapBackedEngineReplication.initZeroStateForAllPossibleRemoteIdentifiers(modIterState);
        this.identifier = identifier;
        this.store = store;
        this.changeApplier = changeApplier;
        this.getValue = getValue;
    }

    @Override
    public byte identifier() {
        return this.identifier;
    }

    private void resetNextBootstrapTimestamp(int remoteIdentifier) {
        Instances i = threadLocalInstances.get();
        i.identifier.setValue(remoteIdentifier);
        do {
            i.usingState = this.modIterState.getUsing(i.identifier, i.usingState);
            i.copyState.copyFrom(i.usingState);
            i.copyState.setNextBootstrapTimestamp(0L);
        } while (!this.modIterState.replaceIfEqual(i.identifier, i.usingState, i.copyState));
    }

    private boolean setNextBootstrapTimestamp(int remoteIdentifier, long timestamp) {
        Instances i = threadLocalInstances.get();
        i.identifier.setValue(remoteIdentifier);
        do {
            i.usingState = this.modIterState.getUsing(i.identifier, i.usingState);
            if (i.usingState.getNextBootstrapTimestamp() != 0L) {
                return false;
            }
            i.copyState.copyFrom(i.usingState);
            i.copyState.setNextBootstrapTimestamp(0L);
        } while (!this.modIterState.replaceIfEqual(i.identifier, i.usingState, i.copyState));
        return true;
    }

    private void resetLastBootstrapTimestamp(int remoteIdentifier) {
        Instances i = threadLocalInstances.get();
        i.identifier.setValue(remoteIdentifier);
        do {
            i.usingState = this.modIterState.getUsing(i.identifier, i.usingState);
            i.copyState.copyFrom(i.usingState);
            i.copyState.setLastBootstrapTimestamp(0L);
        } while (!this.modIterState.replaceIfEqual(i.identifier, i.usingState, i.copyState));
    }

    private long bootstrapTimestamp(int remoteIdentifier) {
        long nextBootstrapTs;
        Instances i = threadLocalInstances.get();
        i.identifier.setValue(remoteIdentifier);
        do {
            i.usingState = this.modIterState.getUsing(i.identifier, i.usingState);
            nextBootstrapTs = i.usingState.getNextBootstrapTimestamp();
            if (nextBootstrapTs == 0L) {
                return i.usingState.getLastBootstrapTimestamp();
            }
            i.copyState.copyFrom(i.usingState);
            i.copyState.setLastBootstrapTimestamp(nextBootstrapTs);
        } while (!this.modIterState.replaceIfEqual(i.identifier, i.usingState, i.copyState));
        return nextBootstrapTs;
    }

    @Override
    public long lastModificationTime(byte remoteIdentifier) {
        return this.lastModificationTime(ChronicleMapBackedEngineReplication.idToInt(remoteIdentifier));
    }

    private long lastModificationTime(int remoteIdentifier) {
        Instances i = threadLocalInstances.get();
        i.identifier.setValue(remoteIdentifier);
        i.usingState = this.modIterState.getUsing(i.identifier, i.usingState);
        return i.usingState.getLastModificationTime();
    }

    @Override
    public void setLastModificationTime(byte identifier, long timestamp) {
        this.setLastModificationTime(ChronicleMapBackedEngineReplication.idToInt(identifier), timestamp);
    }

    private void setLastModificationTime(int identifier, long timestamp) {
        block1: {
            Instances i = threadLocalInstances.get();
            i.identifier.setValue(identifier);
            do {
                i.usingState = this.modIterState.getUsing(i.identifier, i.usingState);
                if (i.usingState.getLastModificationTime() >= timestamp) break block1;
                i.copyState.copyFrom(i.usingState);
                i.copyState.setLastModificationTime(timestamp);
            } while (!this.modIterState.replaceIfEqual(i.identifier, i.usingState, i.copyState));
            return;
        }
    }

    private static boolean shouldApplyRemoteModification(EngineReplication.ReplicationEntry remoteEntry, ReplicationData localReplicationData) {
        long originTimestamp;
        long remoteTimestamp = remoteEntry.timestamp();
        return remoteTimestamp > (originTimestamp = localReplicationData.getTimestamp()) || remoteTimestamp == originTimestamp && remoteEntry.identifier() <= localReplicationData.getIdentifier();
    }

    @Override
    public void applyReplication(@NotNull EngineReplication.ReplicationEntry replicatedEntry) {
        Instances i = threadLocalInstances.get();
        BytesStore key = replicatedEntry.key();
        while (true) {
            boolean shouldApplyRemoteModification;
            ReplicationData data;
            if ((data = this.keyReplicationData.getUsing(key, i.usingData)) != null) {
                i.usingData = data;
            }
            if (!(shouldApplyRemoteModification = data == null || ChronicleMapBackedEngineReplication.shouldApplyRemoteModification(replicatedEntry, data))) continue;
            i.newData.copyFrom(data != null ? data : i.zeroData);
            this.changeApplier.applyChange(this.store, replicatedEntry);
            i.newData.setDeleted(replicatedEntry.isDeleted());
            i.newData.setIdentifier(replicatedEntry.identifier());
            i.newData.setTimestamp(replicatedEntry.timestamp());
            if (data == null) {
                if (this.keyReplicationData.putIfAbsent(key, i.newData) != null) continue;
                return;
            }
            ReplicationData.dropChange(i.newData);
            if (this.keyReplicationData.replaceIfEqual(key, data, i.newData)) break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EngineReplication.ModificationIterator acquireModificationIterator(byte id) {
        int remoteIdentifier = ChronicleMapBackedEngineReplication.idToInt(id);
        EngineReplication.ModificationIterator modificationIterator = this.modificationIterators.get(remoteIdentifier);
        if (modificationIterator != null) {
            return modificationIterator;
        }
        AtomicReferenceArray<ChronicleMapBackedModificationIterator> atomicReferenceArray = this.modificationIterators;
        synchronized (atomicReferenceArray) {
            modificationIterator = this.modificationIterators.get(remoteIdentifier);
            if (modificationIterator != null) {
                return modificationIterator;
            }
            ChronicleMapBackedModificationIterator newModificationIterator = new ChronicleMapBackedModificationIterator(remoteIdentifier);
            this.modificationIteratorsRequiringSettingBootstrapTimestamp.set((long)remoteIdentifier);
            this.resetNextBootstrapTimestamp(remoteIdentifier);
            this.resetLastBootstrapTimestamp(remoteIdentifier);
            this.modificationIterators.set(remoteIdentifier, newModificationIterator);
            this.modIterSet.set((long)remoteIdentifier);
            return newModificationIterator;
        }
    }

    public void onPut(BytesStore key, long putTimestamp) {
        this.onChange(key, false, putTimestamp);
    }

    public void onRemove(BytesStore key, long remoteTimestamp) {
        this.onChange(key, true, remoteTimestamp);
    }

    private void onChange(BytesStore key, boolean deleted, long changeTimestamp) {
        boolean bl;
        boolean successfulUpdate;
        Instances i = threadLocalInstances.get();
        do {
            ReplicationData data;
            if ((data = this.keyReplicationData.getUsing(key, i.usingData)) != null) {
                i.usingData = data;
            }
            i.newData.copyFrom(data != null ? data : i.zeroData);
            i.newData.setDeleted(deleted);
            long entryTimestamp = i.newData.getTimestamp();
            if (entryTimestamp > changeTimestamp) {
                changeTimestamp = entryTimestamp + 1L;
            }
            i.newData.setTimestamp(changeTimestamp);
            i.newData.setIdentifier(this.identifier);
            ReplicationData.raiseChange(i.newData);
            if (data == null) {
                if (this.keyReplicationData.putIfAbsent(key, i.newData) == null) {
                    bl = true;
                    continue;
                }
                bl = false;
                continue;
            }
            bl = this.keyReplicationData.replaceIfEqual(key, data, i.newData);
        } while (!(successfulUpdate = bl));
        long next = this.modIterSet.nextSetBit(0L);
        while (next > 0L) {
            ChronicleMapBackedModificationIterator modIter = this.modificationIterators.get((int)next);
            modIter.modNotify();
            if (this.modificationIteratorsRequiringSettingBootstrapTimestamp.clearIfSet(next) && !this.setNextBootstrapTimestamp((int)next, changeTimestamp)) {
                throw new AssertionError();
            }
            next = this.modIterSet.nextSetBit(next + 1L);
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.keyReplicationData.close();
        }
        finally {
            this.modIterState.close();
        }
    }

    class ChronicleMapBackedModificationIterator
    implements EngineReplication.ModificationIterator,
    EngineReplication.ReplicationEntry {
        private final int identifier;
        long forEachEntryCount;
        EngineReplication.ModificationNotifier modificationNotifier;
        BytesStore key;
        ReplicationData replicationData;

        ChronicleMapBackedModificationIterator(int identifier) {
            this.identifier = identifier;
        }

        @Override
        public void forEach(@NotNull Consumer<EngineReplication.ReplicationEntry> consumer) {
            this.forEachEntryCount = 0L;
            Instances i = (Instances)threadLocalInstances.get();
            ChronicleMapBackedEngineReplication.this.keyReplicationData.keySetIterator().forEachRemaining(key -> {
                instances.usingData = (ReplicationData)ChronicleMapBackedEngineReplication.this.keyReplicationData.getUsing(key, instances.usingData);
                if (ReplicationData.isChanged(instances.usingData, this.identifier)) {
                    this.key = key;
                    this.replicationData = instances.usingData;
                    try {
                        consumer.accept(this);
                        instances.newData.copyFrom(instances.usingData);
                        ReplicationData.clearChange(instances.newData, this.identifier);
                        if (!ChronicleMapBackedEngineReplication.this.keyReplicationData.replaceIfEqual(key, instances.usingData, instances.newData)) {
                            throw new AssertionError();
                        }
                        ++this.forEachEntryCount;
                    }
                    finally {
                        this.key = null;
                        this.replicationData = null;
                    }
                }
            });
            if (this.forEachEntryCount == 0L) {
                ChronicleMapBackedEngineReplication.this.modificationIteratorsRequiringSettingBootstrapTimestamp.set((long)this.identifier);
                ChronicleMapBackedEngineReplication.this.resetNextBootstrapTimestamp(this.identifier);
            }
        }

        @Override
        public boolean hasNext() {
            Instances i = (Instances)threadLocalInstances.get();
            Iterator keyIt = ChronicleMapBackedEngineReplication.this.keyReplicationData.keySetIterator();
            while (keyIt.hasNext()) {
                BytesStore key = (BytesStore)keyIt.next();
                i.usingData = (ReplicationData)ChronicleMapBackedEngineReplication.this.keyReplicationData.getUsing(key, i.usingData);
                if (!ReplicationData.isChanged(i.usingData, this.identifier)) continue;
                return true;
            }
            return false;
        }

        @Override
        public void dirtyEntries(long fromTimeStamp) throws InterruptedException {
            Instances i = (Instances)threadLocalInstances.get();
            ChronicleMapBackedEngineReplication.this.keyReplicationData.keySetIterator().forEachRemaining(key -> {
                instances.usingData = (ReplicationData)ChronicleMapBackedEngineReplication.this.keyReplicationData.getUsing(key, instances.usingData);
                if (instances.usingData.getTimestamp() >= fromTimeStamp) {
                    instances.newData.copyFrom(instances.usingData);
                    ReplicationData.setChange(instances.newData, this.identifier);
                    if (!ChronicleMapBackedEngineReplication.this.keyReplicationData.replaceIfEqual(key, instances.usingData, instances.newData)) {
                        throw new AssertionError();
                    }
                }
            });
        }

        @Override
        public void setModificationNotifier(@NotNull EngineReplication.ModificationNotifier modificationNotifier) {
            this.modificationNotifier = modificationNotifier;
        }

        public void modNotify() {
            if (this.modificationNotifier != null) {
                this.modificationNotifier.onChange();
            }
        }

        @Override
        public BytesStore key() {
            return this.key;
        }

        @Override
        public BytesStore value() {
            return ChronicleMapBackedEngineReplication.this.getValue.getValue(ChronicleMapBackedEngineReplication.this.store, this.key);
        }

        @Override
        public long timestamp() {
            return this.replicationData.getTimestamp();
        }

        @Override
        public byte identifier() {
            return this.replicationData.getIdentifier();
        }

        @Override
        public boolean isDeleted() {
            return this.replicationData.getDeleted();
        }

        @Override
        public long bootStrapTimeStamp() {
            return ChronicleMapBackedEngineReplication.this.bootstrapTimestamp(this.identifier);
        }
    }

    static class Instances {
        final IntValue identifier = (IntValue)DataValueClasses.newInstance(IntValue.class);
        RemoteNodeReplicationState usingState = null;
        final RemoteNodeReplicationState copyState = (RemoteNodeReplicationState)DataValueClasses.newInstance(RemoteNodeReplicationState.class);
        RemoteNodeReplicationState zeroState = (RemoteNodeReplicationState)DataValueClasses.newInstance(RemoteNodeReplicationState.class);
        ReplicationData usingData = null;
        ReplicationData newData = (ReplicationData)DataValueClasses.newInstance(ReplicationData.class);
        ReplicationData zeroData = (ReplicationData)DataValueClasses.newInstance(ReplicationData.class);

        Instances() {
        }
    }

    static interface RemoteNodeReplicationState
    extends Copyable<RemoteNodeReplicationState> {
        public long getNextBootstrapTimestamp();

        public void setNextBootstrapTimestamp(long var1);

        public long getLastBootstrapTimestamp();

        public void setLastBootstrapTimestamp(long var1);

        public long getLastModificationTime();

        public void setLastModificationTime(long var1);
    }

    static interface ReplicationData
    extends Copyable<ReplicationData> {
        public boolean getDeleted();

        public void setDeleted(boolean var1);

        public long getTimestamp();

        public void setTimestamp(long var1);

        public byte getIdentifier();

        public void setIdentifier(byte var1);

        public long getDirtyWord(@MaxSize(value=3) int var1);

        public void setDirtyWord(@MaxSize(value=3) int var1, long var2);

        public static void dropChange(ReplicationData replicationData) {
            for (int i = 0; i < 3; ++i) {
                replicationData.setDirtyWord(i, 0L);
            }
        }

        public static void raiseChange(ReplicationData replicationData) {
            for (int i = 0; i < 3; ++i) {
                replicationData.setDirtyWord(i, -1L);
            }
        }

        public static void clearChange(ReplicationData replicationData, int identifier) {
            int index = identifier / 64;
            long bit = 1L << identifier % 64;
            replicationData.setDirtyWord(index, replicationData.getDirtyWord(index) ^ bit);
        }

        public static void setChange(ReplicationData replicationData, int identifier) {
            int index = identifier / 64;
            long bit = 1L << identifier % 64;
            replicationData.setDirtyWord(index, replicationData.getDirtyWord(index) | bit);
        }

        public static boolean isChanged(ReplicationData replicationData, int identifier) {
            int index = identifier / 64;
            long bit = 1L << identifier % 64;
            return (replicationData.getDirtyWord(index) & bit) != 0L;
        }
    }

    static interface GetValue<Store> {
        public BytesStore getValue(Store var1, BytesStore var2);
    }

    static interface ChangeApplier<Store> {
        public void applyChange(Store var1, EngineReplication.ReplicationEntry var2);
    }
}

