/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.fs;

import net.openhft.chronicle.engine.api.map.MapEvent;
import net.openhft.chronicle.engine.api.map.MapView;
import net.openhft.chronicle.engine.api.pubsub.Subscriber;
import net.openhft.chronicle.engine.api.tree.Asset;
import net.openhft.chronicle.engine.api.tree.AssetTree;
import net.openhft.chronicle.engine.api.tree.RequestContext;
import net.openhft.chronicle.engine.fs.Clusters;
import net.openhft.chronicle.engine.fs.Fstab;
import net.openhft.chronicle.engine.fs.MountPoint;
import net.openhft.chronicle.engine.map.AuthenticatedKeyValueStore;
import net.openhft.chronicle.engine.map.FilePerKeyValueStore;
import net.openhft.chronicle.engine.tree.VanillaAsset;
import net.openhft.chronicle.wire.TextWire;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireOut;
import org.jetbrains.annotations.NotNull;

public class ConfigurationFS
implements MountPoint {
    public static final String FSTAB = "fstab.yaml";
    public static final String CLUSTERS = "clusters.yaml";
    private final String assetName;
    private final String etcDir;
    private final String baseDir;
    private AssetTree assetTree;

    public ConfigurationFS(String assetName, String etcDir, String baseDir) {
        this.assetName = assetName;
        this.etcDir = etcDir;
        this.baseDir = baseDir;
    }

    @Override
    public void install(String baseDir, @NotNull AssetTree assetTree) {
        RequestContext context = RequestContext.requestContext(this.assetName).keyType(String.class).valueType(String.class);
        Asset asset = assetTree.acquireAsset(context);
        if (asset.getView(MapView.class) == null) {
            ((VanillaAsset)asset).enableTranslatingValuesToBytesStore();
            asset.registerView(AuthenticatedKeyValueStore.class, new FilePerKeyValueStore(context.basePath(this.etcDir), asset));
            asset.acquireView(MapView.class, context);
        }
        this.subscribeTo(assetTree);
    }

    public void subscribeTo(@NotNull AssetTree assetTree) {
        this.assetTree = assetTree;
        Subscriber<MapEvent> eventSub = this::onFile;
        assetTree.registerSubscriber(this.assetName, MapEvent.class, eventSub);
    }

    public void onFile(@NotNull MapEvent<String, String> mapEvent) {
        switch ((String)mapEvent.key()) {
            case "fstab.yaml": {
                this.processFstab((String)mapEvent.value());
                break;
            }
            case "clusters.yaml": {
                this.processClusters((String)mapEvent.value());
            }
        }
    }

    private void processClusters(@NotNull String value) {
        Clusters clusters = new Clusters();
        clusters.readMarshallable((WireIn)TextWire.from((String)value));
        clusters.install(this.assetTree);
    }

    private void processFstab(@NotNull String value) {
        Fstab fstab = new Fstab();
        fstab.readMarshallable((WireIn)TextWire.from((String)value));
        fstab.install(this.baseDir, this.assetTree);
    }

    public void readMarshallable(WireIn wire) throws IllegalStateException {
        throw new UnsupportedOperationException("todo");
    }

    public void writeMarshallable(WireOut wire) {
        throw new UnsupportedOperationException("todo");
    }

    @Override
    public String spec() {
        return this.etcDir;
    }

    @Override
    public String name() {
        return this.assetName;
    }
}

