/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.fs;

import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import net.openhft.chronicle.engine.api.tree.AssetTree;
import net.openhft.chronicle.engine.api.tree.View;
import net.openhft.chronicle.engine.fs.HostDetails;
import net.openhft.chronicle.wire.Marshallable;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.WriteMarshallable;
import org.jetbrains.annotations.NotNull;

public class Clusters
implements Marshallable,
View {
    private final Map<String, Map<String, HostDetails>> clusterMap = new ConcurrentSkipListMap<String, Map<String, HostDetails>>();

    public void readMarshallable(@NotNull WireIn wire) throws IllegalStateException {
        StringBuilder clusterName = new StringBuilder();
        StringBuilder hostDescription = new StringBuilder();
        while (wire.hasMore()) {
            wire.readEventName(clusterName).marshallable(host -> {
                Map hdMap = this.clusterMap.computeIfAbsent(clusterName.toString(), k -> new ConcurrentSkipListMap());
                while (wire.hasMore()) {
                    host.readEventName(hostDescription).marshallable(details -> {
                        HostDetails hd = new HostDetails();
                        hd.readMarshallable(details);
                        hdMap.put(hostDescription.toString(), hd);
                    });
                }
            });
        }
    }

    public void writeMarshallable(@NotNull WireOut wire) {
        for (Map.Entry<String, Map<String, HostDetails>> entry : this.clusterMap.entrySet()) {
            wire.writeEventName(entry::getKey).marshallable(host -> {
                for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                    wire.writeEventName(entry2::getKey).marshallable((WriteMarshallable)entry2.getValue());
                }
            });
        }
    }

    public void install(@NotNull AssetTree assetTree) {
        assetTree.root().addView(Clusters.class, this);
    }

    public Map<String, HostDetails> get(String cluster) {
        return this.clusterMap.get(cluster);
    }

    public void put(String cluster, Map<String, HostDetails> hostDetailsMap) {
        this.clusterMap.put(cluster, hostDetailsMap);
    }
}

