/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.api.tree;

import java.util.function.BiPredicate;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.util.ThrowingAcceptor;
import net.openhft.chronicle.engine.api.pubsub.InvalidSubscriberException;
import net.openhft.chronicle.engine.api.pubsub.Subscription;
import net.openhft.chronicle.engine.api.tree.AssetNotFoundException;
import net.openhft.chronicle.engine.api.tree.LeafViewFactory;
import net.openhft.chronicle.engine.api.tree.RequestContext;
import net.openhft.chronicle.engine.api.tree.WrappingViewFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Asset
extends Closeable {
    public String name();

    @NotNull
    public Subscription subscription(boolean var1) throws AssetNotFoundException;

    @NotNull
    default public String fullName() {
        Asset parent = this.parent();
        return parent == null ? "/" : (parent.parent() == null ? "/" + this.name() : parent.fullName() + "/" + this.name());
    }

    @Nullable
    public Asset parent();

    @NotNull
    public Asset acquireAsset(RequestContext var1, String var2) throws AssetNotFoundException;

    @Nullable
    default public Asset getAsset(@NotNull String fullName) {
        if (fullName.isEmpty()) {
            return this;
        }
        int pos = fullName.indexOf("/");
        if (pos >= 0) {
            String name1 = fullName.substring(0, pos);
            String name2 = fullName.substring(pos + 1);
            Asset asset = this.getChild(name1);
            if (asset == null) {
                return null;
            }
            return asset.getAsset(name2);
        }
        return this.getChild(fullName);
    }

    @Nullable
    default public Asset findAsset(@NotNull String name) {
        Asset asset = this.getAsset(name);
        Asset parent = this.parent();
        if (asset == null && parent != null) {
            asset = parent.findAsset(name);
        }
        return asset;
    }

    @Nullable
    default public <V> V findView(@NotNull Class<V> viewType) {
        V v = this.getView(viewType);
        Asset parent = this.parent();
        if (v == null && parent != null) {
            v = parent.findView(viewType);
        }
        return v;
    }

    @Nullable
    default public <V> V findOrCreateView(@NotNull Class<V> viewType) {
        V v = this.getView(viewType);
        if (v == null) {
            if (this.hasFactoryFor(viewType)) {
                return this.acquireView(viewType, RequestContext.requestContext());
            }
            Asset parent = this.parent();
            if (parent != null) {
                v = parent.findOrCreateView(viewType);
            }
        }
        return v;
    }

    public <V> boolean hasFactoryFor(Class<V> var1);

    public Asset getChild(String var1);

    public void removeChild(String var1);

    public boolean isReadOnly();

    @NotNull
    default public <V> V acquireView(@NotNull RequestContext rc) throws AssetNotFoundException {
        return this.acquireView(rc.viewType(), rc);
    }

    @NotNull
    public <V> V acquireView(Class<V> var1, RequestContext var2) throws AssetNotFoundException;

    @Nullable
    public <V> V getView(Class<V> var1);

    public <I> void registerView(Class<I> var1, I var2);

    public <W, U> void addWrappingRule(Class<W> var1, String var2, BiPredicate<RequestContext, Asset> var3, WrappingViewFactory<W, U> var4, Class<U> var5);

    public <W, U> void addWrappingRule(Class<W> var1, String var2, WrappingViewFactory<W, U> var3, Class<U> var4);

    public <L> void addLeafRule(Class<L> var1, String var2, LeafViewFactory<L> var3);

    public <I, U> I createWrappingView(Class var1, RequestContext var2, Asset var3, U var4) throws AssetNotFoundException;

    public <I> I createLeafView(Class var1, RequestContext var2, Asset var3) throws AssetNotFoundException;

    public <V> V addView(Class<V> var1, V var2);

    public boolean isSubAsset();

    @NotNull
    default public Asset root() {
        return this.parent() == null ? this : this.parent().root();
    }

    public boolean hasChildren();

    public void forEachChild(ThrowingAcceptor<Asset, InvalidSubscriberException> var1) throws InvalidSubscriberException;
}

