/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.server.internal;

import java.util.function.Consumer;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.network.connection.CoreFields;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.Wires;
import net.openhft.chronicle.wire.WriteMarshallable;
import net.openhft.chronicle.wire.YamlLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractHandler {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractHandler.class);
    Wire outWire = null;

    void setOutWire(Wire outWire) {
        this.outWire = outWire;
    }

    void writeData(Bytes inBytes, @NotNull Consumer<WireOut> c) {
        this.outWire.writeDocument(false, out -> {
            long readPosition = inBytes.readPosition();
            long position = this.outWire.bytes().writePosition();
            try {
                c.accept((WireOut)this.outWire);
            }
            catch (Throwable t) {
                inBytes.readPosition(readPosition);
                LOG.info("While reading " + inBytes.toDebugString(), (Object)(" processing wire " + c), (Object)t);
                this.outWire.bytes().writePosition(position);
                this.outWire.writeEventName(() -> "exception").throwable(t);
            }
            if (position == this.outWire.bytes().writePosition()) {
                this.outWire.writeEventName((WireKey)CoreFields.reply).marshallable(WriteMarshallable.EMPTY);
            }
        });
        if (YamlLogging.showServerWrites) {
            try {
                System.out.println("server-writes:\n" + Wires.fromSizePrefixedBlobs((Bytes)this.outWire.bytes(), (long)0L, (long)this.outWire.bytes().writePosition()));
            }
            catch (Exception e) {
                System.out.println("server-writes:\n" + this.outWire.bytes().toDebugString());
            }
        }
    }

    public static void nullCheck(@Nullable Object o) {
        if (o == null) {
            throw new NullPointerException();
        }
    }
}

