/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.server;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.engine.api.tree.AssetTree;
import net.openhft.chronicle.engine.api.tree.RequestContext;
import net.openhft.chronicle.engine.server.WireType;
import net.openhft.chronicle.engine.server.internal.EngineWireHandler;
import net.openhft.chronicle.network.AcceptorEventHandler;
import net.openhft.chronicle.network.VanillaSessionDetails;
import net.openhft.chronicle.threads.Threads;
import net.openhft.chronicle.threads.api.EventHandler;
import net.openhft.chronicle.threads.api.EventLoop;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ServerEndpoint
implements Closeable {
    private EventLoop eg;
    private AcceptorEventHandler eah;
    private AtomicBoolean isClosed = new AtomicBoolean();

    public ServerEndpoint(AssetTree assetTree) throws IOException {
        this(0, assetTree);
    }

    public ServerEndpoint(int port, AssetTree assetTree) throws IOException {
        this.eg = assetTree.root().acquireView(EventLoop.class, RequestContext.requestContext());
        Threads.withThreadGroup((ThreadGroup)assetTree.root().getView(ThreadGroup.class), () -> {
            this.start(port, assetTree);
            return null;
        });
    }

    @Nullable
    public AcceptorEventHandler start(int port, @NotNull AssetTree asset) throws IOException {
        this.eg.start();
        AcceptorEventHandler eah = new AcceptorEventHandler(port, () -> new EngineWireHandler(WireType.wire, asset, this.isClosed), VanillaSessionDetails::new);
        this.eg.addHandler((EventHandler)eah);
        this.eah = eah;
        return eah;
    }

    public int getPort() throws IOException {
        return this.eah.getLocalPort();
    }

    public void stop() {
        this.eg.stop();
    }

    public void close() {
        this.isClosed.set(true);
        this.stop();
        Closeable.closeQuietly((Object)this.eg);
        this.eg = null;
        Closeable.closeQuietly((Object)this.eah);
        this.eah = null;
    }
}

